% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_importance.R
\name{plot.importance}
\alias{plot.importance}
\title{Plot importance measures}
\usage{
\method{plot}{importance}(x, ..., top = 10, radar = TRUE,
  text_start_point = 0.5, text_size = 3.5, xmeasure = "sumCover",
  ymeasure = "sumGain")
}
\arguments{
\item{x}{a result from the \code{importance} function.}

\item{...}{other parameters.}

\item{top}{number of positions on the plot or NULL for all variable. Default 10.}

\item{radar}{TRUE/FALSE. If TRUE the plot shows
six measures of variables' or interactions' importance in the model.
If FALSE the plot containing two chosen measures
of variables' or interactions' importance in the model.}

\item{text_start_point}{place, where the names of the particular feature start. Available for `radar=TRUE`. Range from 0 to 1. Default 0.5.}

\item{text_size}{size of the text on the plot. Default 3.5.}

\item{xmeasure}{measure on the x-axis.Available for `radar=FALSE`. Default "sumCover".}

\item{ymeasure}{measure on the y-axis. Available for `radar=FALSE`. Default "sumGain".}
}
\value{
a ggplot object
}
\description{
This functions plots selected measures of importance for variables and interactions.
It is possible to visualise importance table in two ways: radar plot with six measures
and scatter plot with two choosen measures.
}
\details{
Available measures:
\itemize{
\item "sumGain" - sum of Gain value in all nodes, in which given variable occurs,
\item "sumCover" - sum of Cover value in all nodes, in which given variable occurs; for LightGBM models: number of observation, which pass through the node,
\item "mean5Gain" - mean gain from 5 occurrences of given variable with the highest gain,
\item "meanGain" - mean Gain value in all nodes, in which given variable occurs,
\item "meanCover" - mean Cover value in all nodes, in which given variable occurs; for LightGBM models: mean number of observation, which pass through the node,
\item "freqency" - number of occurrences in the nodes for given variable.
}

Additionally for plots with single variables:
\itemize{
\item "meanDepth"  - mean depth weighted by gain,
\item "numberOfRoots" - number of occurrences in the root,
\item "weightedRoot" - mean number of occurrences in the root, which is weighted by gain.
}
}
\examples{
library("EIX")
library("Matrix")
sm <- sparse.model.matrix(left ~ . - 1,  data = HR_data)

library("xgboost")
param <- list(objective = "binary:logistic", max_depth = 2)
xgb_model <- xgboost(sm, params = param, label = HR_data[, left] == 1, nrounds = 25, verbose=0)

imp <- importance(xgb_model, sm, option = "both")
imp
plot(imp,  top = 10)

imp <- importance(xgb_model, sm, option = "variables")
imp
plot(imp,  top = nrow(imp))

 imp <- importance(xgb_model, sm, option = "interactions")
 imp
plot(imp,  top =  nrow(imp))

 imp <- importance(xgb_model, sm, option = "variables")
 imp
plot(imp, top = NULL, radar = FALSE, xmeasure = "sumCover", ymeasure = "sumGain")

\donttest{
library(lightgbm)
train_data <- lgb.Dataset(sm, label =  HR_data[, left] == 1)
params <- list(objective = "binary", max_depth = 2)
lgb_model <- lgb.train(params, train_data, 25)

imp <- importance(lgb_model, sm, option = "both")
imp
plot(imp,  top = nrow(imp))

imp <- importance(lgb_model, sm, option = "variables")
imp
plot(imp, top = NULL, radar = FALSE, xmeasure = "sumCover", ymeasure = "sumGain")

}

}
