% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{ELCIC.gee.single}
\alias{ELCIC.gee.single}
\title{Calculate ELCIC value for a given candidate model under GEE framework with complete longitudinal data or data missing completely at random.}
\usage{
ELCIC.gee.single(x, y, r, id, time, index.var=NULL, name.var = NULL,
                     dist, corstr, joints=TRUE)
}
\arguments{
\item{x}{A matrix containing covariates. The first column should be all ones corresponding to the intercept. If y and x are missing completely at random, use NA to indicate missingness and specify argument "r".}

\item{y}{A vector containing outcomes. If y and x are missing completely at random, use NA to indicate missing outcomes and specify argument "r".}

\item{r}{A vector indicating the observation of data: 1 for observed records (both outcome and covariates are observed for a given subject), and 0 for unobserved records. The default setup is that all data are observed.}

\item{id}{A vector indicating subject id.}

\item{time}{The number of observations in total for each subject}

\item{index.var}{A vector containing index corresponding to candidate covariates. See more in details section.}

\item{name.var}{A vector containing names of candidate covariates. The names should be subset of column names of x matrix. See more in details section.}

\item{dist}{A specified distribution. It can be "gaussian", "poisson",and "binomial".}

\item{corstr}{A candidate correlation structure. It can be either of "independence","exchangeable", and "ar1".}

\item{joints}{A logic value for joint selection of marginal mean and working correlation structure. The default is TRUE. See more in details section.}
}
\value{
A ELCIC value for a given candidate model.
}
\description{
The function \code{\link{ELCIC.gee.single}} calculates ELCIC value for a given marginal mean candidate model with a specified working correlation structure. It is able to simultaneously evaluate mean model and working correlation structure.
}
\details{
Either arguments "index.var" or "name.var" is used to identify the candidate mean model. If both arguments are provided, only the argument "name.var" will be used.

When the argument "joints" is TRUE, \code{\link{ELCIC.gee.single}} will calculate ELCIC value based on the function \code{\link{lambda.find.gee}} and \code{\link{ee.gee}}, which involve estimating equations for both marginal mean and correlation coefficient. When the argument "joints" is FALSE, \code{\link{ELCIC.gee.single}} will calculate ELCIC value based on the function \code{\link{lambda.find.gee.mean}} and \code{\link{ee.gee.mean}}, which only involve estimating equations for marginal mean.
}
\examples{
## tests
# load data
data(geesimdata)
x<-geesimdata$x
y<-geesimdata$y
id<-geesimdata$id
r<-rep(1,nrow(x))
time<-3
corstr<-"exchangeable"
dist<-"poisson"
criteria<-ELCIC.gee.single(x=x,y=y,r=r,id=id,time=time,index.var=c(1,2,3),
           name.var=NULL,dist=dist,corstr=corstr)
criteria

}
