% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELISAtools_IO.R
\name{read.annotation}
\alias{read.annotation}
\title{Read the annotation of single ELISA plate}
\usage{
read.annotation(annotation, std.conc)
}
\arguments{
\item{annotation}{characters to specify the path and name of the annotation file}

\item{std.conc}{data.frame containing standard concentration data. 
Only first two columns are used with first one to be the standard IDs
and second the concentrations.}
}
\value{
a list of data.frames holding the annotations for the plate.
}
\description{
Parse the annotations for one single ELISA plate from
   a section of a file and output the annotations for standard and unknown
	separately.
}
\details{
The annotation file may contain annotations for more than
	one plate. Each plate is marked by "Plate: plate 1..." and 
	"~End". This function is fed in with the content for each section
	and we do actually parsing in here. Store the annotations into 
	data frame. It also parse the standard concentration and 
	include this information in the data frame.
	For each section,we expect
	the following format\cr
\tabular{llllllll}{
   \tab	1\tab	2\tab		3\tab		4\tab 			...\cr	
  C\tab	s1\tab	s1\tab		sample1\tab		sample1\tab	...\cr
  D\tab	s2\tab	s2\tab		sample2\tab		sample\tab  ...\cr	
...\tab	...\tab	...\tab		...\tab		...\tab		...\cr
}
	In addition, the row name and column names indicate the
	the plate row and column indices.
	As input, the stardard and unknown are returned separately in two 
	tables.
}
\examples{
#get example annotation file path from the system folder
fileName<-system.file("extdata", "annote_single.txt", package="ELISAtools")
#prepare the standard concentration file.
std.conc<-data.frame(id=c("s1","s2","s3","s4","s5","s6"), conc=c(1:6))
#read the data as a data frame.
ann<-read.table(fileName, header=TRUE,  sep="\\t", stringsAsFactors=FALSE)

#call to do the reading.
}
