% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{runFit}
\alias{runFit}
\title{Fit 5- or 4-parameter logistic function}
\usage{
runFit(pars, a, d, batches, refBatch.ID = 1, model = c("5pl", "4pl"))
}
\arguments{
\item{pars}{numeric vector initial values to estimate the paramters}

\item{a}{numeric the initial value for a (the lower limit of the function)}

\item{d}{numeric the initial value for d (the upper limit of the function)}

\item{batches}{list of the batch data used to fit the model}

\item{refBatch.ID}{numeric or string indicating the 
reference batch, by default is set to be the first one.}

\item{model}{characters to indicate either 5-parameter logistic
function (5pl, default one) or 4-parameter logistic (4pl) to 
be used in the fitting.}
}
\value{
the batch data with the fitted model
}
\description{
Fit 5- or 4-parameter logistic function to estimate the parameters
by pooling the standard curves from all batches
}
\details{
In this fitting, we first "guess" the initial values and then estimate
the parameters based on 5- or 4-parameter function by shifting every single standard 
curves towards the reference line. 
 We are reasoning that the intra-batch and 
inter-batch factors affect the curve similarly by shifting the curve 
left or right without changing its shapes. So we combine them together to
to fit one single reference curve. To model the inter-batch effects, we
take the average of the shifts of curves withine each batch, and use it
to correct/normalize between different batches. \cr
To summerize, each individual curve has its own shifts, which contains 
the information about intra- and inter-batch effects. each batch has
one batch level shifts (S Factor), which is an average of shifts of 
curves within its batch and contains information about inter-batch effects.
When we try to normalize between batches, we will apply the batch level shift to 
all the curves within the same batch.
}
\examples{
#R code to run 5-parameter logistic regression on ELISA data
#load the library
library(ELISAtools)

#get file folder
dir_file<-system.file("extdata", package="ELISAtools")

batches<-loadData(file.path(dir_file,"design.txt"))

#make a guess for the parameters, the other two parameters a and d 
#will be estimated based on data.
model<-"5pl"
pars<-c(7.2,0.5, 0.015) #5pl inits
names(pars)<-c("xmid", "scal", "g")


#do fitting. model will be written into data set.
batches<-runFit(pars=pars,  batches=batches, refBatch.ID=1, model=model  )

}
\references{
Feng, et al 2018 \doi{10.1101/483800}
}
