% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoxBAR.R
\name{CoxBAR}
\alias{CoxBAR}
\title{CoxBAR}
\usage{
CoxBAR(trainx, y, weight = NULL, maxiter = 5, standardize = TRUE)
}
\arguments{
\item{trainx}{The covariates(predictor variables) of training data.}

\item{y}{Survival time and censored status of training data. Must be a Surv  \code{survival} object}

\item{weight}{In ELMCoxBAR, we set this to a random Cox-Lasso estimate.}

\item{maxiter}{Maximum values of iterations to update the CoxBAR estimator. Default is 5.}

\item{standardize}{Logical flag for trainx variable standardization, prior to fitting the model sequence. Default is standardize=TRUE}
}
\value{
Object of class \code{CoxBAR} with elements
  \tabular{ll}{
      \code{meanx} \tab  Mean values of original trainx if standardization is TRUE. \cr
      \code{sdx} \tab  Standard deviation values of original trainx if standardization is TRUE. \cr
      \code{standardize} \tab  The standardization status. \cr
      \code{beta}    \tab   The point  estimates of \eqn{\beta}. \cr
      \code{logLik} \tab  Log Likelihood. \cr
       
  }
}
\description{
Cox's Regression with broken adaptive ridge (CoxBAR)
}
\examples{
set.seed(123)
require(ELMSurv)
require(survival)
#Lung DATA
data(lung)
lung=na.omit(lung)
lung[,3]=lung[,3]-1
n=dim(lung)[1]
L=sample(1:n,ceiling(n*0.5))
trset<-lung[L,]
teset<-lung[-L,]
rii=c(2,3)
# A randon weight for illustration purpose.
p=dim(lung)[2]-2
myweight=rep(0.5,p)
coxbarmodel=CoxBAR(trainx=trset[,-rii],y=Surv(trset[,rii[1]], trset[,rii[2]]),weight=myweight)
}
\references{
\itemize{
  \item Wang, H, Li, G. Extreme learning machine Cox model for high-dimensional survival analysis. Statistics in Medicine.2019; 38:2139-2156. 
 }
}
\author{
Hong Wang
}
