% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_mcmc}
\alias{plot_mcmc}
\title{Plot MCMC}
\usage{
plot_mcmc(
  emc,
  selection = "mu",
  fun = "cumuplot",
  layout = NA,
  chain = 1,
  plot_type = NULL,
  ...
)
}
\arguments{
\item{emc}{An emc object}

\item{selection}{A Character string. Indicates which parameter type to plot (e.g., \code{alpha}, \code{mu}, \code{sigma2}, \code{correlation}).}

\item{fun}{A plot function that takes a vector/mcmc object as input, e.g. cumuplot, acf}

\item{layout}{A vector indicating which layout to use as in par(mfrow = layout). If NA, will automatically generate an appropriate layout.}

\item{chain}{Integer, which chain to include, if more than 1 will make separate plots per chain.}

\item{plot_type}{type argument passed on to coda fun.}

\item{...}{Optional arguments that can be passed to \code{get_pars},
the chosen coda plot function, or \code{plot.default} (see \code{par()})}
}
\value{
A coda plot
}
\description{
Uses the coda plot functions that are applied per chain
}
