% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_funcs.R
\name{hypothesis.emc}
\alias{hypothesis.emc}
\alias{hypothesis}
\title{Within-model hypothesis testing}
\usage{
\method{hypothesis}{emc}(
  emc,
  parameter = NULL,
  H0 = 0,
  fun = NULL,
  selection = "mu",
  do_plot = TRUE,
  use_prior_lim = TRUE,
  N = 10000,
  prior_plot_args = list(),
  ...
)

hypothesis(emc, ...)
}
\arguments{
\item{emc}{An emc object}

\item{parameter}{A string. A parameter which you want to compare to H0. Will not be used if a FUN is specified.}

\item{H0}{An integer. The H0 value which you want to compare to}

\item{fun}{A function. Specifies an operation to be performed on the sampled or mapped parameters.}

\item{selection}{A Character string. Indicates which parameter type to use (e.g., \code{alpha}, \code{mu}, \code{sigma2}, \code{correlation}).}

\item{do_plot}{Boolean. If \code{FALSE} will omit the prior-posterior plot and only return the savage-dickey ratio.}

\item{use_prior_lim}{Boolean. If \code{TRUE} will use xlimits based on prior density, otherwise based on posterior density.}

\item{N}{Integer. How many prior samples to draw}

\item{prior_plot_args}{A list. Optional additional arguments to be passed to plot.default for the plotting of the prior density (see \code{par()})}

\item{...}{Optional arguments that can be passed to \code{get_pars}, \code{density}, or \code{plot.default} (see \code{par()})}
}
\value{
The Bayes factor for the hypothesis against H0.
}
\description{
Approximates the Bayes factor for parameter effects using the savage-dickey ratio.
}
\details{
Note this is different to the computation of the marginal deviance in \code{compare}
since it only considers the group level effect and not the whole model (i.e. subject-level parameters).
For details see: Wagenmakers, Lodewyckx, Kuriyal, & Grasman (2010).
}
\examples{
# Here the emc object has an effect parameter (e.g. m),
# that maps onto a certain hypothesis.
# The hypothesis here is that m is different from zero.
# We can test whether there's a group-level effect on m:
hypothesis(samples_LNR, parameter = "m")
# Alternatively we can also test whether two parameters differ from each other
mdiff <- function(p)diff(p[c("m","m_lMd")])
hypothesis(samples_LNR,fun=mdiff)
}
