% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_TextType.R
\name{set_TextType}
\alias{set_TextType}
\title{set_TextType}
\usage{
set_TextType(file = NULL, text = NULL)
}
\arguments{
\item{file}{path to a file providing formatted input text, see details.}

\item{text}{a plain text character string which will be used directly as the content
of the node if no file is given}
}
\value{
a TextType object that can be coerced into any element inheriting from TextType, see examples
}
\description{
For any EML element of class TextType, this function can be used to generate
 the appropriate EML from a markdown-formatted file.
}
\details{
If the `rmarkdown` package is installed, then the input file can
be a Microsoft Word (.docx) file, a markdown file, or other file
recognized by Pandoc (see http://pandoc.org), which will automate the conversion
to a docbook. Otherwise, the input file should already be in docbook format (with
.xml or .dbk extension).  Note that pandoc comes pre-installed in RStudio and is
required for the rmarkdown package.
}
\examples{
\donttest{
## using a simple character string
a <- set_TextType(text = "This is the abstract")

## Using an external markdown file
f <- system.file("examples/hf205-abstract.md", package = "EML")
a <- set_TextType(f)

## Can also import from methods written in a .docx MS Word file.
f <- system.file("examples/hf205-abstract.docx", package = "EML")
a <- set_TextType(f)

## Documents with title headings use `section` instead of `para` notation
f <- system.file("examples/hf205-methods.docx", package = "EML")
d <- set_TextType(f)
}

}
