% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_entropy.R
\name{get_entropy}
\alias{get_entropy}
\title{Shannon entropy}
\usage{
get_entropy(dat, n, p, g, pi, mu, sigma, ncov = 2)
}
\arguments{
\item{dat}{An \eqn{n\times p} matrix where each row represents an individual observation}

\item{n}{Number of observations.}

\item{p}{Dimension of observation vecor.}

\item{g}{Number of multivariate Gaussian groups.}

\item{pi}{A g-dimensional initial vector of the mixing proportions.}

\item{mu}{A initial  \eqn{p \times g} matrix of the location parameters.}

\item{sigma}{A \eqn{p\times p} covariance matrix if \code{ncov=1}, or a list of g covariance matrices with dimension \eqn{p\times p \times g} if \code{ncov=2}.}

\item{ncov}{Options of structure of sigma matrix;  the default value is 2;
\code{ncov} = 1 for a common covariance matrix that \code{sigma} is a \eqn{p\times p} matrix.
\code{ncov} = 2 for the unequal  covariance/scale matrices that
\code{sigma} represents a list of g matrices with dimension \eqn{p\times p \times g}.}
}
\value{
\item{clusprobs}{The posterior probabilities of the i-th entity that belongs to the j-th group.}
}
\description{
Shannon entropy
}
\details{
The concept of information entropy was introduced by \cite{shannon1948mathematical}.
The entropy of \eqn{y_j} is formally defined as
\deqn{e_j( y_j; \theta)=-\sum_{i=1}^g \tau_i( y_j; \theta) \log\tau_i(y_j;\theta).}
}
\examples{
n<-150
pi<-c(0.25,0.25,0.25,0.25)
sigma<-array(0,dim=c(3,3,4))
sigma[,,1]<-diag(1,3)
sigma[,,2]<-diag(2,3)
sigma[,,3]<-diag(3,3)
sigma[,,4]<-diag(4,3)
mu<-matrix(c(0.2,0.3,0.4,0.2,0.7,0.6,0.1,0.7,1.6,0.2,1.7,0.6),3,4)
dat<-rmix(n=n,pi=pi,mu=mu,sigma=sigma,ncov=2)
en<-get_entropy(dat=dat$Y,n=150,p=3,g=4,mu=mu,sigma=sigma,pi=pi,ncov=2)
}
