% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{bkml}
\alias{bkml}
\alias{bkml,binClstPath-method}
\title{Generate a burstwise .kml file of a \link{binClstPath_instance}.}
\usage{
bkml(obj, folder = "embcDocs", markerRadius = 15, display = FALSE)

\S4method{bkml}{binClstPath}(obj, folder = "embcDocs",
  markerRadius = 15, display = FALSE)
}
\arguments{
\item{obj}{A \link{binClstPath_instance}.}

\item{folder}{A character string indicating the name of the folder in which
the .kml file will be saved. If the folder does not exist it is
automatically created, (defaults to '~/embcDocs').}

\item{markerRadius}{A numeric value indicating the radius of the markers to
be plotted, (defaults to 5 pixels).}

\item{display}{A boolean value (defaults to FALSE) to automatically launch
Google-Earth from within R to visualize the generated .kml document.
(Google Earth must already be installed on the system. In Windows, it must
be associated with the .kml file type.)}
}
\value{
The path/name of the saved kml file.
}
\description{
\code{bkml} generates a burstwise .kml file of a
  \link{binClstPath_instance}, which can be viewed using Google Earth or
  other GIS software. At first issue, this command can take some time because
  bursted segmentation has to be computed.
}
\examples{
\dontrun{
# -- apply EMbC to the example path --
mybcp <- stbc(expth,info=-1)
# -- generate a burstwise kml of the output --
bkml(mybcp)
}
}
\seealso{
\code{\link{pkml}}
}
