\name{calc.aicc}
\alias{calc.aicc}
\alias{get.params}
\title{ Calculate AICc from Maxent model prediction }
\description{ This function calculates AICc for Maxent models based on Warren and Seifert (2011).  	}

\usage{ 
calc.aicc(nparam, occ, predictive.maps)

get.params(model)
}

\arguments{
\item{nparam}{ The number of parameters in a model calculated with the \code{get.params} function. }

\item{occ}{ A data.frame of occurrence localities. }

\item{predictive.maps}{ A raster layer or RasterStack of predicted model surface(s). }

\item{model}{ A Maxent model object generated by the \code{maxent} function in the \pkg{dismo} package. }
}

\details{ 
As motivated by Warren and Seifert (2011) and implemented in ENMTools (Warren  \emph{et al.} 2010), this function calculates the small sample size version of Akaike Information Criterion for ENMs (Akaike 1974).  We use AICc (instead of AIC) regardless of sample size based on the recommendation of Burnham and Anderson (1998, 2004).  The number of parameters is determined by counting the number of non-zero parameters in the \code{maxent} lambda file.  See Warren \emph{et al.} (2014) for limitations of this approach, namely that the number of parameters is an estimate of the true degrees of freedom.  For Maxent ENMs, AICc is calculated by standardizing the raw output such that all cells in the study extent sum to 1.  The likelihood of the data for a given model is then calculated by taking the product of the raw output values for all grid cells that contain an occurrence locality (Warren and Seifert 2011).  
}

\value{
A data.frame with four columns:

\code{AICc} is the Akaike Information Criterion corrected for small sample sizes calculated as:

\deqn{ (2 * K - 2 * logLikelihood) + (2 * K) * (K+1) / (n - K - 1)} 

where \emph{K} is the number of parameters in the model (i.e., number of non-zero parameters in Maxent lambda file) and \emph{n} is the number of occurrence localities.  The \emph{logLikelihood} is calculated as:

\deqn{ sum(log(vals / total))}

where \emph{vals} is a vector of Maxent raw values at occurrence localities and \emph{total} is the sum of Maxent raw values across the entire study area.  

\code{delta.AICc} is the difference between the AICc of a given model and the AICc of the model with the lowest AICc.  

\code{w.AICc} is the Akaike weight (calculated as the relative likelihood of a model (exp(-0.5 * \code{delta.AICc})) divided by the sum of the likelihood values of all models included in a run.  These can be used for model averaging (Burnham and Anderson 2002).  

\code{nparam} is the number of parameters in a Maxent model (number of non-zero parameters in the lambda file) and is used internally during a call of \code{calc.aicc} by \code{get.params}.
}

\note{
Returns all \code{NA}s if the number of parameters is larger than the number of observations (occurrence localities).

This function could produce erroneous results in version 0.1.0. when calculating AICc on multiple models simultaneously.  This problem has been addressed in version 0.1.1.
}

\references{
Akaike, H. (1974) A new look at the statistical model identification. \emph{IEEE Transactions on Automatic Control}, \bold{19}: 716-723.

Burnham, K. P. and Anderson, D. R. (1998) Model selection and multimodel inference: a practical information-theoretic approach. Springer, New York.

Burnham, K. P. and Anderson, D. R. (2004) Multimodel inference: understanding AIC and BIC in model selection. \emph{Sociological Methods and Research}, \bold{33}: 261-304.

Warren, D. L., Glor, R. E, and Turelli, M. (2010) ENMTools: a toolbox for comparative studies of environmental niche models. \emph{Ecography}, \bold{33}: 607-611.

Warren, D. L. and Seifert, S. N. (2011) Ecological niche modeling in Maxent: the importance of model complexity and the performance of model selection criteria. \emph{Ecological Applications}, \bold{21}: 335-342.

Warren, D. L., Wright, A. N., Seifert, S. N., and Shaffer, H. B. (2014) Incorporating model complexity and sampling bias into ecological niche models of climate change risks faced by 90 California vertebrate species of concern. \emph{Diversity and Distributions}, \bold{20}: 334-343.

}

\author{ Robert Muscarella <bob.muscarella@gmail.com> and Jamie M. Kass <jkass@gc.cuny.edu> }
\seealso{
\code{maxent} in the \pkg{dismo} package.
}