% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EVT_utils.R
\name{fit_GPD_unconditional}
\alias{fit_GPD_unconditional}
\title{Maximum likelihood estimates for the GPD distribution using peaks over threshold}
\usage{
fit_GPD_unconditional(Y, interm_lvl = NULL, thresh_quantiles = NULL)
}
\arguments{
\item{Y}{Vector of observations}

\item{interm_lvl}{Probability level at which the empirical quantile should be used as the threshold,
if \code{thresh_quantiles} is not given.}

\item{thresh_quantiles}{Numerical value or numerical vector of the same length as \code{Y}
representing either a fixed or a varying threshold, respectively.}
}
\value{
Named list containing:
\item{scale}{the GPD scale MLE,}
\item{shape}{the GPD shape MLE,}
\item{fit}{the fitted \code{\link[ismev:gpd.fit]{ismev::gpd.fit()}} object.}
}
\description{
Maximum likelihood estimates for the GPD distribution using peaks over threshold
}
