\name{esgplotts}
\alias{esgplotts}
\title{Plot time series objects}
\usage{
  esgplotts(x)
}
\arguments{
  \item{x}{a time series object, an output from
  \code{\link{simdiff}}.}
}
\description{
  This function plots outputs from \code{\link{simdiff}}.
}
\details{
  For a large number of simulations, it's preferable to use
  \code{\link{esgplotbands}} for a synthetic view by
  percentiles.
}
\examples{
kappa <- 1.5
V0 <- theta <- 0.04
sigma <- 0.2
theta1 <- kappa*theta
theta2 <- kappa
theta3 <- sigma
x <- simdiff(n = 10, horizon = 5, frequency = "quart",
model = "OU",
x0 = V0, theta1 = theta1, theta2 = theta2, theta3 = theta3)

esgplotts(x)
}
\author{
  Thierry Moudiki
}
\references{
  H. Wickham (2009), ggplot2: elegant graphics for data
  analysis. Springer New York.
}
\seealso{
  \code{\link{simdiff}}, \code{\link{esgplotbands}}
}

