% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aic.R
\name{aic}
\alias{aic}
\title{Computes the Akaike Information Criterion}
\usage{
aic(mod)
}
\arguments{
\item{mod}{A fitted model of class \code{lm} or \code{merMod}.}
}
\description{
Computes the Akaike Information Criterion of a model. Except when the number
of observations is much larger than the number of parameters (i.e., n / k > 40),
we apply the second-order bias correction for small samples (AICc), as suggested by
Burnham & Anderson (2002, 2004).
}
\examples{
data(mtcars)
mod1 <- lm(mpg ~ cyl, mtcars)
aic(mod1)

}
\references{
Burnham, K. P., \& Anderson, D. R. (2002). Model Selection
and Multimodel Inference: A Practical Information-Theoretical Approach.
2d ed. New York: Springer-Verlag.

Burnham, K. P., \& Anderson, D. R. (2004). Multimodel
inference: Understanding AIC and BIC in model selection. Sociological
Methods and Research, 33(2), 261-304.
}
\seealso{
\code{\link{bic}}, \code{\link{ictab}}
}
\author{
Ladislas Nalborczyk <\email{ladislas.nalborczyk@gmail.com}>
}
