\name{read.odbc.ffdf}
\alias{read.odbc.ffdf}
\title{Read data from a ODBC connection into an ffdf.}
\usage{
  read.odbc.ffdf(query = NULL,
    odbcConnect.args = list(dsn = NULL, uid = "", pwd = ""),
    odbcQuery.args = list(), sqlGetResults.args = list(),
    x = NULL, nrows = -1, first.rows = NULL,
    next.rows = NULL, levels = NULL, appendLevels = TRUE,
    asffdf_args = list(),
    BATCHBYTES = getOption("ffbatchbytes"),
    VERBOSE = FALSE, colClasses = NULL, transFUN = NULL,
    ...)
}
\arguments{
  \item{query}{the SQL query to execute on the ODBC
  connection}

  \item{odbcConnect.args}{a list of arguments to pass to
  ODBC's \code{\link[RODBC]{odbcConnect}} (like dsn, uid,
  pwd). See the examples.}

  \item{odbcQuery.args}{a list of arguments to pass to
  ODBC's \code{\link[RODBC]{odbcQuery}}, like rows_at_time.
  Defaults to an empty list.}

  \item{sqlGetResults.args}{a list containing optional
  parameters which will be passed to
  \code{\link[RODBC]{sqlGetResults}}. Defaults to an empty
  list. The max parameter will be overwritten with
  first.rows and next.rows when importing in batches.}

  \item{x}{NULL or an optional ffdf object to which the
  read records are appended. See documentation in
  \code{\link[ff]{read.table.ffdf}} for more details and
  the example below.}

  \item{nrows}{Number of rows to read from the query
  resultset. Default value of -1 reads in all rows.}

  \item{first.rows}{chunk size (rows) to read for first
  chunk from the query resultset}

  \item{next.rows}{chunk size (rows) to read sequentially
  for subsequent chunks from the query resultset.
  Currently, this must be specified.}

  \item{levels}{optional specification of factor levels. A
  list with as names the names the columns of the
  data.frame fetched in the first.rows, containing levels
  of the factors.}

  \item{appendLevels}{logical. A vector of permissions to
  expand levels for factor columns. See documentation in
  \code{\link[ff]{read.table.ffdf}} for more details.}

  \item{asffdf_args}{further arguments passed to
  \code{\link[ff]{as.ffdf}} (ignored if 'x' gives an ffdf
  object)}

  \item{BATCHBYTES}{integer: bytes allowed for the size of
  the data.frame storing the result of reading one chunk.
  See documentation in \code{\link[ff]{read.table.ffdf}}
  for more details.}

  \item{VERBOSE}{logical: TRUE to verbose timings for each
  processed chunk (default FALSE).}

  \item{colClasses}{See documentation in
  \code{\link[ff]{read.table.ffdf}}}

  \item{transFUN}{function applied to the data frame after
  each chunk is retreived by
  \code{\link[RODBC]{sqlGetResults}}}

  \item{...}{optional parameters passed on to transFUN}
}
\value{
  An ffdf object unless the query returns zero records in
  which case the function will return the data.frame
  returned by \code{\link[RODBC]{sqlGetResults}} and
  possibly transFUN.
}
\description{
  Read data from a ODBC connection into an
  \code{\link[ff]{ffdf}}. This can for example be used to
  import large datasets from Oracle, SQLite, MySQL,
  PostgreSQL or other SQL databases into R. \cr
}
\details{
  Opens up the ODBC connection using
  \code{RODBC::odbcConnect}, sends the query using
  \code{RODBC::odbcQuery} and retrieves the results in
  batches of next.rows rows using
  \code{RODBC::sqlGetResults}. Heavily borrowed from
  \code{\link[ff]{read.table.ffdf}}
}
\examples{
##
## Using the sqlite database (smalldb.sqlite3) in the /inst folder of the package
## set up the sqlite ODBC driver (www.stats.ox.ac.uk/pub/bdr/RODBC-manual.pd) and call it 'smalltestsqlitedb'
##
\dontrun{
require(RODBC)
x <- read.odbc.ffdf(
query = "select * from testdata limit 10000",
odbcConnect.args = list(dsn="smalltestsqlitedb", uid = "", pwd = ""),
nrows = -1,
first.rows = 100, next.rows = 1000, VERBOSE = TRUE)
}
}
\author{
  Jan Wijffels
}
\seealso{
  \code{\link[ff]{read.table.ffdf}, \link{read.dbi.ffdf}}
}

