% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollsd.R
\name{rollsd}
\alias{rollsd}
\title{Rolling standard deviation}
\usage{
rollsd(cases, lag_t = 7)
}
\arguments{
\item{cases}{the time series of the newly observed cases per unit of time (ideally per day).}

\item{lag_t}{integer - the size of the rolling window for which the rolling standard deviation is calculated (minimum/default value = 7, maximum recommended value = 30).}
}
\value{
Returns a vector with the estimated rolling standard deviation for a time series.
}
\description{
This function computes the rolling standard deviation for a time series.
}
\examples{
data("Italy")
cases = mova(cases=Italy$Cases, r_a = 7)
roll = rollsd(cases=cases,lag_t = 7)

}
\references{
Kostoulas, P., Meletis, E., Pateras, K. et al. The epidemic volatility index, a novel early warning tool for identifying new waves in an epidemic. Sci Rep 11, 23775 (2021). \doi{10.1038/s41598-021-02622-3}
}
