% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-analysis.R
\name{stronger_than}
\alias{stronger_than}
\title{Estimate proportion of population effect sizes above or below a threshold}
\usage{
stronger_than(q, yr, vyr = NA, t2, vt2 = NA, CI.level = 0.95, tail)
}
\arguments{
\item{q}{True effect size that is the threshold for "scientific importance"}

\item{yr}{Pooled point estimate from meta-analysis}

\item{vyr}{Estimated variance of pooled point estimate from meta-analysis}

\item{t2}{Estimated heterogeneity (tau^2) from meta-analysis}

\item{vt2}{Estimated variance of tau^2 from meta-analysis}

\item{CI.level}{Confidence level as a proportion}

\item{tail}{\code{above} for the proportion of effects above \code{q}; \code{below} for
the proportion of effects below \code{q}.}
}
\description{
Estimates the proportion of true effect sizes in a meta-analysis above or below
a specified threshold of scientific importance. Effect sizes may be of any type (they need not
be relative risks). This is a wrapper for \code{confounded_meta}; it is the special case in
which there is no unmeasured confounding.
}
\keyword{meta-analysis}
