% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EValue.R
\name{twoXtwoRR}
\alias{twoXtwoRR}
\title{Estimate risk ratio and compute CI limits from two-by-two table}
\usage{
twoXtwoRR(n11, n10, n01, n00, alpha = 0.05)
}
\arguments{
\item{n11}{Number exposed (X=1) and diseased (D=1)}

\item{n10}{Number exposed (X=1) and not diseased (D=0)}

\item{n01}{Number unexposed (X=0) and diseased (D=1)}

\item{n00}{Number unexposed (X=0) and not diseased (D=0)}

\item{alpha}{Alpha level associated with confidence interval}
}
\description{
Given counts in a two-by-two table, computes risk ratio and confidence
interval limits.
}
\examples{
# Hammond and Holl (1958 JAMA) Data
# Two by Two Table
#          Lung Cancer    No Lung Cancer
# Smoker    397            78557
# Nonsmoker 51             108778

twoXtwoRR(397, 78557, 51, 108778)
}
