% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_am.R
\name{SummaryAM}
\alias{SummaryAM}
\title{Summary of multiple locus association mapping results}
\usage{
SummaryAM(AMobj = NULL)
}
\arguments{
\item{AMobj}{the (list) object obtained from running \code{\link{AM}}.}
}
\description{
A summary function that provides additional information on the significant 
    marker-trait associations found by \code{\link{AM}}
}
\details{
\code{SummaryAM} produces two  tables, an overall summary table and a table  of results with 
the  p-value for each 
fixed effect in the final model.
}
\examples{
 \dontrun{
  # Since the following code takes longer than 5 seconds to run, it has been tagged as dontrun. 
  # However, the code can be run by the user. 
  #

  #---------------
  # read the map 
  #---------------
  #
  # File is a plain space separated text file with the first row 
  # the column headings
  complete.name <- system.file('extdata', 'map.txt', 
                                   package='Eagle')
  map_obj <- ReadMap(filename=complete.name) 

 # to look at the first few rows of the map file
 head(map_obj)

  #------------------
  # read marker data
  #------------------
  # Reading in a PLINK ped file 
  # and setting the available memory on the machine for the reading of the data to 8 gigabytes
  complete.name <- system.file('extdata', 'geno.ped', 
                                     package='Eagle')
  geno_obj <- ReadMarker(filename=complete.name,  type='PLINK', availmemGb=8) 
 
  #----------------------
  # read phenotype data
  #-----------------------

  # Read in a plain text file with data on a single trait and two fixed effects
  # The first row of the text file contains the column names y, cov1, and cov2. 
  complete.name <- system.file('extdata', 'pheno.txt', package='Eagle')
  
  pheno_obj <- ReadPheno(filename=complete.name)
           
  #-------------------------------------------------------
  # Perform multiple-locus genome-wide association mapping 
  #-------------------------------------------------------                   
  res <- AM(trait = 'y',
                           fformula=c("cov1 + cov2"),
                           map = map_obj,
                           pheno = pheno_obj,
                           geno = geno_obj)

  #-----------------------------------------
  # Produce additional summary information 
  #------------------------------------------

  SummaryAM(AMobj=res)
 }



}
\seealso{
\code{\link{AM}}
}
