% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotAM.R
\name{PlotAM}
\alias{PlotAM}
\title{Visualisation of multiple locus association mapping results}
\usage{
PlotAM(
  AMobj = NULL,
  itnum = 1,
  chr = "All",
  type = "Manhattan",
  interactive = TRUE
)
}
\arguments{
\item{AMobj}{the (list) object obtained from running \code{\link{AM}}.}

\item{itnum}{the iteration number of the model building process whose results are to be viewed.}

\item{chr}{either "All" for all chromosomes or the label of a specific chromosome.}

\item{type}{either "Manhattan" or  "Score"  for a manhattan plot or a plot of the 
score statistics across SNPs.}

\item{interactive}{boolean parameter. When \code{TRUE}, an interactive plot is generated. When 
\code{FALSE}, a ggplot object is returned which can be saved as an image to file}
}
\description{
A interactive plotting function that provides additional information on the significant 
    marker-trait associations found by \code{\link{AM}}
}
\details{
A function useful for viewing the strength of association across the whole genome and 
 how this association changes as the model is built. 

 The  score statistics (\code{type="Score"}) or p-values  of the score statistics
 (\code{type="Manhattan"}) are plotted against the location of the SNPs.  The orange
 vertical  lines 
 denote the location of the SNPs already found by \code{\link{AM}}. 
 The red vertical line is the location of the SNP in strongest association with the trait 
 at that iteration number. 

 The vertical lines are numbered according to the order in which the snp-trait associations were found by the model. 

 A single chromosome or all (\code{chr="All"}) chromosomes can be viewed.  

 By setting \code{itnum} to different values, how the score statistics or p-values 
 increase/decrease 
 over the model building process can be observed.
}
\examples{
 \dontrun{
  # Since the following code takes longer than 5 seconds to run, it has been tagged as dontrun. 
  # However, the code can be run by the user. 
  #

  #---------------
  # read the map 
  #---------------
  #
  # File is a plain space separated text file with the first row 
  # the column headings
  complete.name <- system.file('extdata', 'map.txt', 
                                   package='Eagle')
  map_obj <- ReadMap(filename=complete.name) 

 # to look at the first few rows of the map file
 head(map_obj)

  # read marker data
  complete.name <- system.file('extdata', 'geno.ped', 
                                     package='Eagle')
  geno_obj <- ReadMarker(filename=complete.name,  type='PLINK', availmemGb=8) 
 
  # read phenotype data
  complete.name <- system.file('extdata', 'pheno.txt', package='Eagle')
  
  pheno_obj <- ReadPheno(filename=complete.name)
           
  # Perform multiple-locus genome-wide association mapping 
  res <- AM(trait = 'y',
                           fformula=c("cov1 + cov2"),
                           map = map_obj,
                           pheno = pheno_obj,
                           geno = geno_obj)

 # Plotting the p-values from the first iteration of the module building process. 
 # You can see why Eagle has identified the SNP that is has. 
  PlotAM(AMobj=res, itnum=1)


 # Plotting the results from the final step of the model building process
 # By accounting for the effect of SNP in strong association with the trait, the 
 # strength of association changes across the genome. 
  PlotAM(AMobj=res, itnum=3)


 # Suppose you want to save the above plot to a jpeg file called myplot.jpg
 jpeg("./myplot.jpg", width=1200, height=800)
 PlotAM(AMobj=res, itnum=3, interactive=FALSE)
 dev.off()


 }



}
\seealso{
\code{\link{AM}}
}
