% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserFunctions.R
\name{setMutationMatrix}
\alias{setMutationMatrix}
\title{Setting the mutation matrix}
\usage{
setMutationMatrix(genomeObj, mutHapLoci, mutDipLoci)
}
\arguments{
\item{genomeObj}{a \code{Genome} object}

\item{mutHapLoci}{a list of haploid locus by locus allelic mulation matrices.}

\item{mutDipLoci}{a list of diploid locus by locus allelic mulation matrices.}
}
\value{
a \code{MutationMatrix} object
}
\description{
Generation of the mutation matrix associated with the genome given as input
and specifying the mutation matrices locus by locus by the arguments
\code{mutHapLoci} and \code{mutDipLoci}.
}
\details{
A mutation matrix is used to simulate mutations that affect loci. An object
of the class \code{MutationMatrix} does not only contain a (genotypic)
mutation matrix. It also contains the attributes necessary for the
construction and easy-to-read display of this matrix.

The mutation matrix itself is a square matrix of size equal to the number of
genotypes. It is a probability matrix in that the sum of the values in
each row is equal to 1. For a given genotype, the row associated with it
describes the probabilistic proportions that lead by mutation of this
genotype to the production of the other genotypes (and of itself if there
are no mutations).
}
\examples{
### Example with two loci, each with two alleles ###
# Definition of the diploid locus
LD <- list(dl = as.factor(c("A", "a")))
# Definition of the haploid locus
HL <- list(hl = as.factor(c("B", "b")))
# Definition of the object of Genome class
genomeObj <- setGenome(listHapLoci = HL, listDipLoci = LD)
# The mutation matrices can be defined as follows:
mutHapLoci <- list(matrix(c(0.9, 0.1, 0.1, 0.9), 2))
mutDipLoci <- list(matrix(c(0.99, 0.01, 0.01, 0.99), 2))
# One can then define the MutationMatrix class object:
setMutationMatrix(genomeObj, mutHapLoci, mutDipLoci)

}
\author{
Ehouarn Le Faou
}
