% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserFunctions.R
\name{setSelectOnGametesProd}
\alias{setSelectOnGametesProd}
\title{Setting the selection on gamete production}
\usage{
setSelectOnGametesProd(
  genomeObj = NULL,
  indProdFit = c(),
  femProdFit = c(),
  maleProdFit = c(),
  selectionObj = NULL
)
}
\arguments{
\item{genomeObj}{a \code{Genome} object}

\item{indProdFit}{a genotypic fitness vector for all individuals}

\item{femProdFit}{a genotypic fitness vector for females only}

\item{maleProdFit}{a genotypic fitness vector for males only}

\item{selectionObj}{a \code{Selection} object (in the case where the
selection on individuals is overlaid on an existing \code{Selection} object)}
}
\value{
a \code{Selection} object
}
\description{
Generation of an object of the \code{Selection} class which defines a
selection on the gamete production either by adding this type of selection
to an already existing \code{SelectionObj} object (parameter
\code{selectionObj}) or by creating one.
}
\examples{
DL <- list(dl = c("A", "a"))
HL <- list(hl = c("B", "b"))
genomeObj <- setGenome(listHapLoci = HL, listDipLoci = DL)
selectionObj <- setSelectOnGametesProd(
  genomeObj = genomeObj,
  indProdFit = c(1, 1, 1, 1, 0.5, 0)
)

}
\author{
Ehouarn Le Faou
}
