\name{binary_model_cluster}
\alias{binary_model_cluster}
\title{
  Wrapper for a binary executable for parallel simulations}
\description{
  This function enables to link a binary executable to a \code{R} function.
}
\usage{
  binary_model_cluster(command)}
\arguments{
  \item{command}{
	a character string indicating the command to launch the executable on your system.}
}
\details{
  A binary executable used with \code{binary_model_cluster} has to be placed in the current directory of the \code{R} session.
  It further has to respect several constraints: 
  1- it has to have a single argument: a number \code{k} used by the binary executable to know in which files read and write.
  2- it has to read the seed for its pseudo-random number generator and the model parameters in a file "inputk" (where k is the argument passed to the executable: input1, input2,...).
  3- it has to write the summary statistic in a file "outputk" (where k is the argument passed to the executable: output1, output2,...).
  The file "inputk" will be generated by the wrapper \code{binary_model_cluster} in the current directory of the \code{R} session, and the wrapper will read the file "outputk" generated by the binary executable.
  This construction ensures that each core reads and writes in different files.
  In the file "inputk", the first line contains the seed, and each subsequent line contains one model parameter value.
  In the file "outputk", each summary statistic should be separated by a space or a tab separation.
  This wrapper should be used for use with multiple cores of the computer. If the user wishes to use a single core of the computer, the wrapper \code{\link{binary_model}} should be used.
  Note that the files "inputk" and "outputk" are deleted by the wrapper at the end of the function.
}
\value{
	A \code{R} function wrapping the binary executable, to be used with the \code{EasyABC} functions.
}
%\references{}
\author{Franck Jabot, Thierry Faure and Nicolas Dumoulin}
\seealso{
  \code{\link{binary_model}}, \code{\link{ABC_rejection}}, \code{\link{ABC_sequential}}, \code{\link{ABC_mcmc}}
}
\examples{
  \dontrun{%
    ## artificial example to show how to use the binary_model function with an executable "My_Executable"
    ABC_rej<-ABC_rejection(model=binary_model_cluster("./My_Executable"), prior=..., n_cluster=2,...)
    # NB: on windows, "My_Executable" should be of the form "My_Executable.exe" :
    ABC_rej<-ABC_rejection(model=binary_model_cluster("./My_Executable.exe"), prior=..., n_cluster=2,...)
  }
}
\keyword{abc}
\keyword{model}
\keyword{inference}


