% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsemblePrior-class.R
\docType{class}
\name{EnsemblePrior-class}
\alias{EnsemblePrior-class}
\title{A class to hold the priors for the ensemble model.}
\description{
An \code{EnsemblePrior} object encapsulates the prior information for the ensemble model.
}
\section{Slots}{

\describe{
\item{\code{d}}{A \code{numeric} specifying the number of variables of interest in the ensemble.}

\item{\code{ind_st_params}}{A \code{list} containing a prior specification for the individual short-term discrepancies \eqn{z_k^{(t)}}. See details of the \code{EnsemblePrior()} constructor.}

\item{\code{ind_lt_params}}{A \code{list} containing a prior specification for the individual long-term discrepancies \eqn{\gamma_k}. See details of the \code{EnsemblePrior()} constructor.}

\item{\code{sha_st_params}}{A \code{list} containing a prior specification for the shared short-term discrepancies \eqn{\eta^{(t)}}. See details of the \code{EnsemblePrior()} constructor.}

\item{\code{sha_lt_params}}{A \code{numeric} containing the standard deviations for the normal prior used on the shared short-term discrepancy \eqn{\mu}. If a single value is supplied,  this is repeated for each variable}

\item{\code{truth_params}}{A \code{list} containing a prior specification for the processes on the truth \eqn{y^{(t)}}. See details of the \code{EnsemblePrior()} constructor. The default value is \code{TruthPrior(d)}.}

\item{\code{priors_stan_input}}{A \code{list} containing the prior data in the correct form to fit the model in Stan. This information is automatically generated by the constructor.}
}}

\references{
Stan Development Team (2020). RStan: the R interface to Stan. R package version 2.21.2. https://mc-stan.org

Lewandowski, Daniel, Dorota Kurowicka, and Harry Joe. 2009. “Generating Random Correlation Matrices Based on Vines and Extended Onion Method.” Journal of Multivariate Analysis 100: 1989–2001.
}
