% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.autocor.R
\name{eco.autocor}
\alias{eco.autocor}
\title{Moran's I, Geary's C and Join-Count  correlograms for an ecogen object.}
\usage{
eco.autocor(eco, fact = NA, int, smax, nsim = 99, select = c("moran",
  "geary", "join-count"), d.class = c("alleles", "locus", "phenotype"),
  grp = NA, style = c("B", "W", "C", "U", "minmax", "S"),
  zero.policy = TRUE)
}
\arguments{
\item{eco}{ecogen object.}

\item{fact}{The name of the S slot column when analysis per-group is required.
Default analysis takes in account all sites.}

\item{int}{Interval distance for the analysis.}

\item{smax}{Maximum distance for the analysis.}

\item{nsim}{Number of Monte - Carlo simulations.}

\item{select}{The analysis type ("moran", "geary", "join-count").}

\item{d.class}{The class of data to analyze ("alleles", "locus",
"phenotype").}

\item{grp}{The group (contained in x) to analyze if analysis
per-group is required. Default analysis takes in account all sites.}

\item{style}{Weights matrix style passed to \code{\link[spdep]{nb2listw}}.
Can take  the values "W", "B", "C", "U", "minmax" and "S".}

\item{zero.policy}{Default TRUE assign zero to the lagged value
of zones without neighbors, if FALSE assign NA, if NULL use global option
value.}
}
\value{
An object of class "RelDist" with data frames for the statistic
and the 95\% upper and lower confidence interval bounds estimated by
bootstrap.
}
\description{
This program can manipulate different class of data.
For data of class "allele" the program takes the data frame allocated
in the GENIND slot. For data of class "locus", the program takes
the data frame of the G slot and transforms the genotypes
of the individual loci into factor levels (e.g., for a biallelic loci
with alleles A and B, three levels could be present in the data:
"AA","AB","BB"). Before the "locus" analysis, it is necessary
to run \code{\link{eco.sortalleles}} in codominant diploid
 data if the alleles are not ordered (e.g., 15 and 51 will
 be interpreted as two levels).  For data of class "phenotype"
  the data frame used is the allocated in the P slot.
For "allele" and "phenotype" data, "moran", "geary" and
"join-count" analysis are available (the user must match
their data with the  statistic, according to the class of analysis,
data is taken as factor with join-count).
For "locus" data, only join-count is available.
}
\examples{
\dontrun{
data(eco.test)
eco.ac <- eco.autocor(eco, int = 50, smax = 1000, d.class = "phenotype")
plot(eco.ac, var = 6)
plot(eco.ac, var = 3)

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\seealso{
\code{\link[spdep]{moran}} \code{\link[spdep]{geary}}
\code{\link[spdep]{joincount.test}}
}

