% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.pairtest.R
\name{eco.pairtest}
\alias{eco.pairtest}
\title{Wilcoxon (Mann-Whitney U) and Tukey-HSD tests for an ecogen object.}
\usage{
eco.pairtest(eco, df = c("P", "E", "C"), x, test = c("wilcoxon", "tukey"),
  adjust = c("fdr", "holm", "hochberg", "hommel", "bonferroni", "BH", "BY",
  "none"), only.p = TRUE, ...)
}
\arguments{
\item{eco}{Ecogen object.}

\item{df}{The data frame for the analysis. Could be "P", "E" or "C".}

\item{x}{The name of the S slot column with the groups for the analysis.}

\item{test}{Test to perform ("wilcoxon", "tukey").}

\item{adjust}{The p.value adjustment method passed to \code{\link{p.adjust}}.
for the Wilkoxon tests. Defalut is "fdr".}

\item{only.p}{Should be only returned a matrix with P values?
Default TRUE.}

\item{...}{Additional arguments passed to \code{\link{wilcox.test}}
or  \code{\link{TukeyHSD}}.}
}
\description{
Wilcoxon (Mann-Whitney U) and Tukey-HSD tests for an ecogen object.
}
\details{
This program returns the Wilcoxon (Mann-Whitney U) or Tukey-HSD
statistics and p values for the multiple comparisons of the variables contained
in the selected data frame,  among the levels of a factor of the slot "S".
}
\examples{
\dontrun{

data(eco.test)
wil <- eco.pairtest(eco = eco, df = "P", x = "structure")
wil <- eco.pairtest(eco = eco,df = "E", x = "structure")
wil <- eco.pairtest(eco = eco, df = "P", x = "structure", only.p = FALSE)
wil <- eco.pairtest(eco = eco,df = "P", x = "structure", test = "tukey")

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\seealso{
\code{\link{wilcox.test}} \code{\link{TukeyHSD}}
}

