% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.2columns.R
\name{eco.2columns}
\alias{eco.2columns}
\title{Converting an ecogen genetic data frame with two alleles per column
into a data frame with one allele per column}
\usage{
eco.2columns(eco, ndig)
}
\arguments{
\item{eco}{ecogen object.}

\item{ndig}{Number of digits coding each allele
(e.g., 1: x, 2: xx, or 3: xxx).}
}
\description{
Converting an ecogen genetic data frame with two alleles per column
into a data frame with one allele per column
}
\examples{
\dontrun{

data(eco.test)
eco.2al <- eco.2columns(eco, 1)
eco.2al
write.table(eco.2al, "one.per.column.txt", quote = FALSE)

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

