% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{sim1}
\alias{sim1}
\title{Sim1 Co-occurrence Randomization Algorithm}
\usage{
sim1(speciesData)
}
\arguments{
\item{speciesData}{binary presence-absence matrix
(rows = species, columns = sites).}
}
\value{
Returns a binary presence-absence matrix with the same
dimensions and percent fill as the input matrix.
}
\description{
Randomizes a binary matrix speciesData by reshuffling
all of its elements equiprobably.
}
\details{
This algorithm assumes species and sites are equiprobable.
It preserves the total matrix fill, but places no other constraints on
row or column totals.
}
\note{
This is the simplest of all randomization algorithms for a presence-
absence matrix. However, it assumes that both species and sites are
equiprobable, and has poor Type I error frequencies when tested with
purely random matrices. If the input matrix is sparse, it will often
generate null matrices with empty rows or columns. Not recommended for
co-occurrence analysis.
}
\examples{
randomMatrix <- sim1(speciesData=matrix(rbinom(40,1,0.5),nrow=8))
}
\references{
Gotelli, N.J. 2000. Null model analysis of species co-occurrence
patterns. Ecology 81: 2606-2621.
}

