% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioGeo.R
\name{extGame}
\alias{extGame}
\title{Zero-sum game}
\usage{
extGame(bet = 1, total = 100, tmax = 2)
}
\arguments{
\item{bet}{bet size of each competitor on each time.}

\item{total}{total amount of resource.}

\item{tmax}{maximum game time.}
}
\value{
'extGame' returns a graphic with the amount of resource of each
competitor on each time.

'extGame' also returns an invisible vector with the results of the loser on
each time.
}
\description{
Simulates a zero-sum game between two competitors with a fixed amount of
resource.
}
\details{
A zero-sum game is a mathematical representation of a situation in which a
participant's gain (or loss) of resource is exactly balanced by the losses
(or gains) of the resource of the other participant(s). If the total gains
of the participants are added up, and the total losses are subtracted, they
will sum to zero.
}
\examples{

\dontrun{
extGame(bet=1,total=20)
extGame(bet=1,total=100)
}

}
\author{
Alexandre Adalardo de Oliveira and Paulo Inacio Prado
\email{ecovirtualpackage@gmail.com}
}
\references{
\url{http://en.wikipedia.org/wiki/Zero-sum_game}
}
\seealso{
\code{\link{simHub}}, \code{\link{randWalk}},
\url{http://ecovirtual.ib.usp.br}
}
\keyword{neutral}
\keyword{simulation}
\keyword{theory}

