% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadPIRLS.R
\name{downloadPIRLS}
\alias{downloadPIRLS}
\title{Download and Unzip PIRLS Files}
\usage{
downloadPIRLS(
  root,
  years = c(2001, 2006, 2011, 2016, 2021),
  cache = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{root}{a character string indicating the directory where the PIRLS
data should be stored. Files are placed in a
subdirectory named PIRLS/[year].}

\item{years}{an integer vector of the assessment years to download. Valid years are 2001, 2006, 2011, 2016, and 2021.}

\item{cache}{a logical value set to process and cache the text (.txt) version of files.
This takes a very long time but saves time for future uses of
the data. Default value is \code{FALSE}.}

\item{verbose}{a logical value to either print or suppress status message output.
The default value is \code{TRUE}.}
}
\description{
Uses an Internet connection to download PIRLS data.
             Data come from \href{https://timssandpirls.bc.edu/}{timssandpirls.bc.edu} zip files. This
             function works for 2001, 2006, 2011, 2016, and 2021 data.
}
\examples{
\dontrun{
# root argument will vary by operating system conventions
downloadPIRLS(year=c(2006, 2011), root = "~/")

# cache=TRUE will download then process the datafiles
downloadPIRLS(year=2011, root = "~/", cache = TRUE)

# set verbose=FALSE for silent output
# if year not specified, download all years
downloadPIRLS(root="~/", verbose = FALSE)
}
}
\seealso{
\code{\link{readPIRLS}}
}
\author{
Tom Fink
}
