% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNHES.R
\name{getNHES_SurveyInfo}
\alias{getNHES_SurveyInfo}
\title{Get NHES Survey Code Definitions and Survey Meta-data}
\usage{
getNHES_SurveyInfo()
}
\description{
This function returns a \code{data.frame} object that defines NHES Survey Codes and survey parameters that are compatible with the \code{readNHES} function for use.
             The resulting \code{data.frame} object is useful for user reference or other advanced techniques.
}
\note{
Any changes or modifications to the \code{data.frame} object will not change the behavior of \code{readNHES}.
      This function should be treated only as a read-only source of information.
}
\examples{
\dontrun{
  #retrieves the NHES survey meta-data to a data.frame
  surveyInfo <- getNHES_SurveyInfo()
  
  #View the survey data where the year is equal to 2016 in RStudio
  View(subset(surveyInfo, surveyInfo$Year==2016))
}
}
\seealso{
\code{readNHES}, \code{viewNHES_SurveyCodes}
}
\author{
Tom Fink
}
