% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star.ctrl.R
\name{star.ctrl}
\alias{star.ctrl}
\title{Control function for effect stars.}
\usage{
star.ctrl(lwd.circle = 1, col.circle = "yellowgreen",
  lty.circle = "solid", col.fill = "yellowgreen", lwd.star = 1.5,
  cex.main = 1.5, cex.labels = 1, col.main = "black",
  col.labels = "black", col.star = "black", dist.labels = 1,
  font.labels = 1, radius = 1)
}
\arguments{
\item{lwd.circle}{Line width of circle.}

\item{col.circle}{Color of circle, possibly a vector with one value per covariate.}

\item{lty.circle}{Line type of circle.}

\item{col.fill}{Color to fill the circle, possibly a vector with one value per covariate.}

\item{lwd.star}{Line width for effect star.}

\item{cex.main}{Size of mains.}

\item{cex.labels}{Size of labels.}

\item{col.main}{Color of mains.}

\item{col.labels}{Colors of labels. Can be a vector (one value/color per category) 
or a even matrix (one column per category, one row per star).}

\item{col.star}{Color of effect star.}

\item{dist.labels}{Tuning parameter for distance of labels 
from effect star. Default is 1, higher values increase the distance of the 
labels to effect stars. Can also be specified as a vector, containing one value per star.}

\item{font.labels}{Font type of labels. Can be a vector (one value/color per category) 
or a even matrix (one column per category, one row per star).}

\item{radius}{Radius for circle. Can also be specified as a vector, containing one value per star.}
}
\description{
Control function to set graphical parameters for method \code{\link{effectstars}}.
}
\examples{
\dontrun{
data(election) 
library(VGAM)

m_elect <- vglm(Partychoice ~ Gender + West + Age + Union + Highschool + Unemployment
+ Pol.Interest + Democracy + Religion, family = multinomial(), data = election)

ctr <- star.ctrl(col.labels = c("black","red2","yellow2","green2","darkred"), col.star = "darkgray",
col.fill = "lightblue", col.circle = "darkgray", cex.labels = 1.1)

effectstars(m_elect, control = ctr)
}

}
\author{
Gunther Schauberger \cr
\email{gunther@stat.uni-muenchen.de} \cr \cr
\url{http://www.statistik.lmu.de/~schauberger/}
}
\references{
Tutz, G. and Schauberger, G. (2013): \emph{Visualization of Categorical Response Models -
from Data Glyphs to Parameter Glyphs}, Journal of Computational and Graphical Statistics 22(1), 156--177.
\cr \cr  Gerhard Tutz (2012): \emph{Regression for Categorical Data}, Cambridge University Press
}
\seealso{
\code{\link{effectstars}}
}

