% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/davids_steepness.R
\name{davids_steepness}
\alias{davids_steepness}
\title{David's scores and steepness with Bayesian flavor}
\usage{
davids_steepness(mat, silent = FALSE, ...)
}
\arguments{
\item{mat}{square interaction matrix}

\item{silent}{logical, suppress warnings (default is \code{FALSE})}

\item{...}{additional arguments for \code{\link[rstan]{sampling}()}}
}
\value{
a list with results of the modelling fitting, containing the
following list items:
\describe{
\item{\code{steepness}}{a one-column matrix with the posterior samples
for steepness. Each row is one iteration.}
\item{\code{norm_ds}}{an matrix with posterior normalized
David's scores for each individual. Each column is one individual.
Each row is one iteration.}
\item{\code{ids}}{a character vector with individual ID codes as supplied
in \code{mat}}
\item{\code{diagnostics}}{a list with information regarding sampling
problems}
\item{\code{stanfit}}{the actual \code{\link[rstan]{stanfit}} object}
\item{\code{mat}}{the input matrix}
}
}
\description{
David's scores and steepness with Bayesian flavor
}
\examples{
data(dommats, package = "EloRating")
res <- davids_steepness(dommats$elephants, refresh = 0)
plot_steepness(res)
}
