% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords.R
\name{kMeansMap}
\alias{kMeansMap}
\title{Create a map from k-Means clusters}
\usage{
kMeansMap(data, k, coordsFn, batch = T, ...)
}
\arguments{
\item{data}{Input data matrix, with individual data points in rows}

\item{k}{How many points to sample}

\item{coordsFn}{a function to generate embedding coordinates (default none)}

\item{batch}{Use batch-SOM training (effectively kMeans, default TRUE)}

\item{...}{Passed to \code{\link[=SOM]{SOM()}}, useful e.g. for 'parallel=T' or 'rlen=5'}
}
\value{
map object (without the grid, if coordsFn was not specified)
}
\description{
May give better results than 'RandomMap' on data where random sampling
is complicated.
This does not use actual kMeans clustering, but re-uses the batch version of
\code{\link[=SOM]{SOM()}} with tiny radius (which makes it work the same as kMeans). In
consequence, the speedup of SOM function is applied here as well. Additionally,
because we don't need that amount of clustering precision, parameters `batch=F, rlen=1'
may give a satisfactory result very quickly.
}
\examples{
d <- iris[,1:4]
EmbedSOM::PlotEmbed(
  EmbedSOM::EmbedSOM(
    data = d,
    map = EmbedSOM::kMeansMap(d, 10, EmbedSOM::GraphCoords())),
  pch=19, clust=iris[,5]
)
}
