% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALGO__PS.R
\name{config_ps}
\alias{config_ps}
\title{Configuration object for the Particle Swarm Algorithm}
\usage{
config_ps(
  iterations,
  population_size,
  iterations_same_cost = NULL,
  absolute_tol = NULL,
  alpha_vel = 0.5,
  alpha_evolution = 1,
  cognitive = 2,
  social = 2,
  inertia = 0.9
)
}
\arguments{
\item{iterations}{maximum number of iterations.}

\item{population_size}{number of particles.}

\item{iterations_same_cost}{maximum number of consecutive iterations with the \emph{same}
(see the parameter \code{absolute_tol}) best cost before ending the minimization. If \code{NULL} the
minimization continues for the number of iterations specified by the parameter \code{iterations}.
Default is \code{NULL}.}

\item{absolute_tol}{absolute tolerance when comparing best costs from consecutive iterations.
If \code{NULL} the machine epsilon is used. Default is \code{NULL}.}

\item{alpha_vel}{maximum velocity of particles, defined as a fraction of the range on
each parameter. Default is \code{0.5}.}

\item{alpha_evolution}{parameter to control the decreasing alpha_vel value with
the iterations. Default is \code{1.0} (linear).}

\item{cognitive}{parameter influencing the motion of the particle on
the basis of distance between its current and best positions. Default is \code{2.0}.}

\item{social}{parameter influencing the motion of the particle on
the basis of distance between its current position and the best position in the swarm. Default is \code{2.0}.}

\item{inertia}{parameter influencing the dependency of the velocity on
its value at the previous iteration. Default \code{0.9}.}
}
\value{
\code{config_ps} returns an object of class \code{PSConfig}.
}
\description{
Create a configuration object for the Particle Swarm Algorithm (PS). At minimum the number of iterations
(parameter \code{iterations}) and the number of particles (parameter \code{population_size}) have
to be provided.
}
\examples{
conf <- config_ps(iterations = 100, population_size = 50, iterations_same_cost = NULL,
absolute_tol = NULL,alpha_vel = 0.5, alpha_evolution = 1.0, cognitive = 2.0,
social = 2.0, inertia = 0.9)

}
\references{
\insertRef{eberhart1995new}{EmiR}
}
