% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read}
\alias{read}
\title{Read NetCDF data from global inventaries}
\source{
read abbout EDGAR at http://edgar.jrc.ec.europa.eu
}
\usage{
read(file, version = "EDGAR 4.3.1 v2", as_raster = T, verbose = T)
}
\arguments{
\item{file}{file name or names (variables are summed)}

\item{version}{inventorie information}

\item{as_raster}{return a raster (defoult) or matrix (with units)}

\item{verbose}{display additional information}
}
\value{
Matrix or raster
}
\description{
Read data from global inventoris
}
\examples{
\donttest{
d1     <- gridInfo(paste(system.file("extdata", package = "EmissV"),"/wrfinput_d01",sep=""))
d2     <- gridInfo(paste(system.file("extdata", package = "EmissV"),"/wrfinput_d02",sep=""))
print("download and untar EDGAR data from:")
print("http://edgar.jrc.ec.europa.eu/gallery.php?release=v431_v2&substance=NOx&sector=TRO")
nox    <- read("v431_v2_REFERENCE_NOx_2010_10_TRO.0.1x0.1.nc")
sp::spplot(nox, scales = list(draw=TRUE), xlab="Lat", ylab="Lon",main="NOx emissions from EDGAR")
nox_d1 <- rasterSource(nox,d1)
nox_d2 <- rasterSource(nox,d2)
image(nox_d1, main = "NOx emissions from transport from EDGAR 3.4.1 for d1")
image(nox_d2, main = "NOx emissions from transport from EDGAR 3.4.1 for d2")
}
}
\seealso{
\code{\link{rasterSource}} and \code{\link{gridInfo}}
}
