% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConfidenceIntervalCalibration.R
\name{fitSystematicErrorModel}
\alias{fitSystematicErrorModel}
\title{Fit a systematic error model}
\usage{
fitSystematicErrorModel(logRr, seLogRr, trueLogRr,
  estimateCovarianceMatrix = FALSE, legacy = FALSE)
}
\arguments{
\item{logRr}{A numeric vector of effect estimates on the log scale.}

\item{seLogRr}{The standard error of the log of the effect estimates. Hint: often
the standard error = (log(<lower bound 95 percent confidence
interval>) - log(<effect estimate>))/qnorm(0.025).}

\item{trueLogRr}{A vector of the true effect sizes.}

\item{estimateCovarianceMatrix}{Should a covariance matrix be computed? If so, confidence
intervals for the model parameters will be available.}

\item{legacy}{If true, a legacy error model will be fitted, meaning standard 
deviation is linear on the log scale. If false, standard deviation
is assumed to be simply linear.}
}
\value{
An object of type \code{systematicErrorModel}.
}
\description{
Fit a systematic error model
}
\details{
Fit a model of the systematic error as a function of true effect size. This model is an extension
of the method for fitting the null distribution. The mean and log(standard deviations) of the error
distributions are assumed to be linear with respect to the true effect size, and each component is
therefore represented by an intercept and a slope.
}
\examples{
controls <- simulateControls(n = 50 * 3, mean = 0.25, sd = 0.25, trueLogRr = log(c(1, 2, 4)))
model <- fitSystematicErrorModel(controls$logRr, controls$seLogRr, controls$trueLogRr)
model

}
