% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EmpiricalCalibrationUsingAsymptotics.R
\name{fitNullNonNormalLl}
\alias{fitNullNonNormalLl}
\title{Fit the null distribution using non-normal log-likelihood approximations}
\usage{
fitNullNonNormalLl(likelihoodApproximations)
}
\arguments{
\item{likelihoodApproximations}{Either a data frame containing normal, skew-normal, or custom parametric likelihood
approximations, or a list of (adaptive) grid likelihood profiles.}
}
\value{
An object containing the parameters of the null distribution.
}
\description{
\code{fitNullNonNormalLl} fits the null distribution to a set of negative controls
}
\details{
This function fits a Gaussian function to the negative control estimates, using non-normal
approximations of the per-negative control log likelihood.
}
\examples{
data(sccs)
negatives <- sccs[sccs$groundTruth == 0, ]
null <- fitNullNonNormalLl(negatives)
null

}
