% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msa.R
\name{msa.merge}
\alias{msa.merge}
\title{Carry Out a MSA of a Set of Different Orthologous Proteins}
\usage{
msa.merge(data, outfile = 'any')
}
\arguments{
\item{data}{input data must be a dataframe where each row corresponds to a protein and each column to a species.}

\item{outfile}{path to the place where a fasta file is going to be saved. If 'any', no file is saved.}
}
\value{
A dataframe containing the MSA (species x position).
}
\description{
Carries out a MSA of a set of different orthologous proteins in different species.
}
\details{
The input data has the same format that the input data used for EnvNJ or SVD-n-Gram methods. Thus, the name of columns must correspond to that of species.
}
\examples{
\dontrun{
data(bovids)
msa.merge(bovids)}
}
\seealso{
msa.tree
}
