% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortest-paths.r
\docType{methods}
\name{ShortestPaths}
\alias{ShortestPaths}
\alias{ShortestPaths,ContactTrace-method}
\alias{ShortestPaths,data.frame-method}
\title{\code{ShortestPaths}}
\usage{
ShortestPaths(x, ...)

\S4method{ShortestPaths}{ContactTrace}(x)

\S4method{ShortestPaths}{data.frame}(x, root, tEnd = NULL, days = NULL,
  inBegin = NULL, inEnd = NULL, outBegin = NULL, outEnd = NULL)
}
\arguments{
\item{x}{a \code{\linkS4class{ContactTrace}} object, or a
\code{data.frame} with movements of animals between holdings, see
\code{\link{Trace}} for details.}

\item{...}{Additional arguments to the method}

\item{root}{vector of roots to calculate shortest path for.}

\item{tEnd}{the last date to include ingoing movements. Defaults
to \code{NULL}}

\item{days}{the number of previous days before tEnd to include
ingoing movements. Defaults to \code{NULL}}

\item{inBegin}{the first date to include ingoing
movements. Defaults to \code{NULL}}

\item{inEnd}{the last date to include ingoing movements. Defaults
to \code{NULL}}

\item{outBegin}{the first date to include outgoing
movements. Defaults to \code{NULL}}

\item{outEnd}{the last date to include outgoing movements. Defaults
to \code{NULL}}
}
\value{
A \code{data.frame} with the following columns:
\describe{
  \item{root}{
    The root of the contact tracing
  }

  \item{inBegin}{
    If the direction is ingoing, then inBegin equals inBegin in
    \code{\link{Trace}} else NA.
  }

  \item{inEnd}{
    If the direction is ingoing, then inEnd equals inEnd in
    \code{\link{Trace}} else NA.
  }

  \item{outBegin}{
    If the direction is outgoing, then outBegin equals outBegin in
    \code{\link{Trace}} else NA.
  }

  \item{outEnd}{
    If the direction is outgoing, then outEnd equals outEnd in
    \code{\link{Trace}} else NA.
  }

  \item{direction}{
    If the direction is ingoing, then direction equals 'in' else 'out'
  }

  \item{source}{
    The source of the contact at distance from root
  }

  \item{destination}{
    The destination of the contact at distance from root
  }

  \item{distance}{
    The shortest distance from/to root in the depth first search
  }
}
}
\description{
Methods for function \code{ShortestPaths} in package \pkg{EpiContactTrace}
to get the shortest distance from/to the root given by the contact tracing.
}
\details{
The contact tracing performs a depth first search starting at the root. The
\code{ShortestPaths} gives the shortest distance from root at each node.
The network tree structure given by the depth first search is shown by
\code{\link{show}}.
}
\section{Methods}{
 \describe{

  \item{\code{signature(object = "ContactTrace")}}{
    Get the shortest paths for the ingoing and outgoing
    \code{Contacts} of a \code{ContactTrace} object.
  }

  \item{\code{signature(x = "data.frame")}}{
    Get the shortest paths for a data.frame with movements,
    see details and examples.
  }
}
}
\examples{
\dontrun{

## Load data
data(transfers)

## Perform contact tracing
contactTrace <- Trace(movements=transfers,
                      root=2645,
                      tEnd='2005-10-31',
                      days=90)

ShortestPaths(contactTrace)

## Calculate shortest paths for all included herds
## First extract all source and destination from the dataset
root <- sort(unique(c(transfers$source, transfers$destination)))

sp <- ShortestPaths(transfers, root=root, tEnd='2005-10-31', days=90)

}
}
\seealso{
\code{\link{show}} and \code{\link{NetworkStructure}}.
}
\keyword{methods}

