% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_Idist_plot.R
\name{plot.Idist}
\alias{plot.Idist}
\title{Plot the interval distribution from an Idist object}
\usage{
\method{plot}{Idist}(x, barcol = "firebrick", denscol = "pink", denstransparent = 0.5,
 barwidth = 0.30, title = NULL, themetype = c("gray","classic","light","dark"),
 titlesize = 15, xtitlesize = 13, ytitlesize = 13, ...)
}
\arguments{
\item{x}{An object of class \code{Idist}.}

\item{barcol}{Color of the discretized interval distribution.}

\item{denscol}{Color of the probability density function (pdf).}

\item{denstransparent}{The transparency of the pdf.}

\item{barwidth}{Width of the bars for the discrete distribution.}

\item{title}{Title of the plot.}

\item{themetype}{Theme of the plot.}

\item{titlesize}{Size of the plot title. Default is 15.}

\item{xtitlesize}{Size of title and text on x axis. Default is 13.}

\item{ytitlesize}{Size of title and text on y axis. Default is 13.}

\item{...}{Further arguments to be passed to plot.}
}
\value{
A plot of the interval distribution.
}
\description{
This routine plots the interval distribution based on an Idist
object.
}
\examples{
x <- Idist(mean = 3, sd = 1.6, dist = "weibull")
plot(x)

}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}
}
