EpiLPS: a fast and flexible Bayesian tool for estimating epidemiological
parameters
================
Oswaldo Gressani (<oswaldo.gressani@uhasselt.be>)

<!-- Introduce badges -->

![Version](https://img.shields.io/badge/Version-1.2.0-MediumSeaGreen)
![Languages](https://img.shields.io/badge/Languages-R%2C%20C%2B%2B-informational)
![Lifecycle](https://img.shields.io/badge/lifecycle-Extending-cyan)
![CodeSize](https://img.shields.io/github/languages/code-size/oswaldogressani/EpiLPS?color=orange&label=Code%20size&style=plastic)
![UserStars](https://img.shields.io/github/stars/oswaldogressani/EpiLPS?style=social)
![MyTwitter](https://img.shields.io/twitter/follow/OswaldoGressani?style=social)

<img src="man/figures/gplv3-or-later.png" width="10%" style="display: block; margin: auto auto auto 0;" />

<br>

**EpiLPS** <span style="color: green;"> (Gressani et al. 2022)</span> is
an **Epi**demiological modeling tool using
**L**aplacian-**P**-**S**plines. It can be used to estimate (key)
epidemiological parameters such as the time-varying reproduction number
(the average number of secondary cases generated by an infected
individual) or the incubation period of an infectious disease. The
website associated to the project <https://epilps.com/> provides a
detailed documentation (or vignette) on how to use the underlying
routines.

#### Citation

Associated literature:

1.  Gressani, O., Wallinga, J., Althaus, C. L., Hens, N. and Faes, C.
    (2022). EpiLPS: A fast and flexible Bayesian tool for estimation of
    the time-varying reproduction number. *PLoS Comput Biol* **18**(10):
    e1010618. <https://doi.org/10.1371/journal.pcbi.1010618>.

2.  Gressani, O., Torneri, A., Hens, N. and Faes, C. (2023). Flexible
    Bayesian estimation of incubation times. MedRxiv preprint.
    <https://www.medrxiv.org/content/10.1101/2023.08.07.23293752v1>.

To cite the EpiLPS package in publications starting from version 1.2.0
use:

    Gressani, O. (2021). EpiLPS: a fast and flexible Bayesian tool for 
    estimating epidemiological parameters. [Computer Software]. https://epilps.com/

For versions before 1.2.0 use:

    Gressani, O. (2021). EpiLPS: a fast and flexible Bayesian tool for 
    estimation of the time-varying reproduction number. [Computer Software]. https://epilps.com/

#### Package version

This is version 1.2.0 (2023-08-07) - “Extension to incubation
estimation”.

#### Acknowledgments

This project is funded by the European Union’s Research and Innovation
Action under the H2020 work programme, EpiPose (grant number 101003688).
It is also supported by the ESCAPE project (101095619) and the VERDI
project (101045989), funded by the European Union.

#### License

EpiLPS: a fast and flexible Bayesian tool for estimating epidemiological
parameters. Copyright (C) 2021-2023 Oswaldo Gressani.

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
Public License for more details.

You should have received a copy of the GNU General Public License along
with this program. If not, see <https://www.gnu.org/licenses/>.
