% Generated by roxygen2 (4.0.1): do not edit by hand
\name{control.net}
\alias{control.net}
\title{Control Settings for Stochastic Network Models}
\usage{
control.net(type, nsteps, nsims, depend, rec.rand, b.rand, d.rand, tea.status,
  attr.rules, epi.by, pid.prefix, initialize.FUN, infection.FUN, recovery.FUN,
  deaths_sus.FUN, deaths_inf.FUN, deaths_rec.FUN, births.FUN, resim_nets.FUN,
  get_prev.FUN, set.control.stergm, save.nwstats, nwstats.formula, delete.nodes,
  save.transmat, save.network, verbose, verbose.int, ...)
}
\arguments{
\item{type}{disease type to be modeled, with the choice of \code{"SI"} for
Susceptible-Infected diseases, \code{"SIR"} for
Susceptible-Infected-Recovered diseases, and \code{"SIS"} for
Susceptible-Infected-Susceptible diseases.}

\item{nsteps}{number of time steps to simulate the model over. This must be a
positive integer.}

\item{nsims}{the total number of disease simulations.}

\item{depend}{if \code{TRUE}, resimulate the network at each time step. This
occurs by default with two varieties of dependent models: if there are
any vital dynamic parameters in the model, or if the network model
formation formula includes the "status" attribute.}

\item{rec.rand}{if \code{TRUE}, use a stochastic recovery model, with the
number of recovered at each time step a function of random draws from
a binomial distribution with the probability equal to \code{rec.rate}.
If \code{FALSE}, then a deterministic rounded count of the expectation
implied by that rate.}

\item{b.rand}{if \code{TRUE}, use a stochastic birth model, with the
number of births at each time step a function of random draws from a
binomial distribution with the probability equal to the governing birth
rates. If \code{FALSE}, then a deterministic rounded count of the
expectation implied by those rates.}

\item{d.rand}{if \code{TRUE}, use a stochastic death model, with the number of
deaths at each time step a function of random draws from a binomial
distribution with the probability equal to the governing death rates.
If \code{FALSE}, then a deterministic rounded count of the expectation
implied by those rates.}

\item{tea.status}{if \code{TRUE}, use a temporally extended attribute (TEA)
to store disease status. A TEA is needed for plotting static networks
at different time steps and for animating dynamic networks with evolving
status. TEAs are computationally inefficient for large simulations and
should be toggled off in those cases.}

\item{attr.rules}{a list containing the  rules for setting the attributes of
incoming nodes, with one list element per attribute to be set (see
details below).}

\item{epi.by}{a character vector of length 1 containing a nodal attribute for
which subgroup epidemic prevalences should be calculated. This nodal
attribute must be contained in the network model formation formula,
otherwise it is ignored.}

\item{pid.prefix}{a character vector of length 2 containing the prefixes for
persistent ids initialized in bipartite networks with vital dynamics,
with the default of \code{c("F", "M")}.}

\item{initialize.FUN}{module to initialize the model at time 1, with the
default function of \code{\link{initialize.net}}.}

\item{infection.FUN}{module to simulate disease infection, with the default
function of \code{\link{infection.net}}.}

\item{recovery.FUN}{module to simulate disease recovery, with the default
function of \code{\link{recovery.net}}.}

\item{deaths_sus.FUN}{module to simulate death or exit among the susceptibles,
with the default function of \code{\link{deaths_sus.net}}.}

\item{deaths_inf.FUN}{module to simulate death or exit among the infecteds,
with the default function of \code{\link{deaths_inf.net}}.}

\item{deaths_rec.FUN}{module to simulate death or exit among the recovered,
with the default function of \code{\link{deaths_rec.net}}.}

\item{births.FUN}{module to simulate births or entries, with the default
function of \code{\link{births.net}}.}

\item{resim_nets.FUN}{module to resimulate the network at each time step,
with the default function of \code{\link{resim_nets}}}

\item{get_prev.FUN}{module to calculate disease prevalence at each time step,
with the default function of \code{\link{get_prev.net}}.}

\item{set.control.stergm}{control arguments passed to simulate.stergm. See the
help file for \code{\link{netdx}} for details and examples on specifying
this parameter.}

\item{save.nwstats}{if \code{TRUE}, save network statistics in a data frame.
The statistics to be saved are specified in the \code{nwstats.formula}
argument.}

\item{nwstats.formula}{a right-hand sided ERGM formula that includes network
statistics of interest, with the default to the formation formula terms.}

\item{delete.nodes}{if \code{TRUE}, delete inactive nodes from the network
after each time step, otherwise deactivate them but keep them in the
network object. Deleting nodes increases computational efficency in
large network simulations.}

\item{save.transmat}{if \code{TRUE}, save a transmission matrix for each
simulation. This object contains one row for each transmission event
(see \code{\link{discord_edgelist}}).}

\item{save.network}{if \code{TRUE}, save a \code{networkDynamic} object
containing full edge history for each simulation. If \code{delete.nodes}
is set to \code{TRUE}, this will only contain a static network with the
edge configuration at the final time step of each simulation.}

\item{verbose}{if \code{TRUE}, print model progress to the console.}

\item{verbose.int}{time step interval for printing progress to console, where
0 prints completion status of entire simulation and positive integer
\code{x} prints progress after each \code{x} time steps. The default
is to print progress after each time step.}

\item{...}{additional control settings passed to model.}
}
\description{
Sets the controls for stochastic network models simulated with
             \code{\link{netsim}}.
}
\details{
\code{control.net} sets the required control settings for any network model
solved with the \code{\link{netsim}} function. Controls are required for both
built-in model types and when passing original process modules. For an overview
of control settings for built-in network models, consult the
\href{http://statnet.org/EpiModel/vignette/Tutorial.pdf}{EpiModel Tutorial}.
For all built-in models, the \code{type} argument is a necessary parameter
and it has no default.
}
\section{The attr.rules Argument}{

The \code{attr.rules} parameter is used to specify the rules for how nodal
attribute values for incoming nodes should be set. These rules are only
necessary for models in which there are incoming nodes (i.e., births) and also
there is a nodal attribute in the network model formation formula set in
\code{\link{netest}}. There are three rules available for each attribute
value:
\itemize{
 \item \strong{"current":} new nodes will be assigned this attribute in
       proportion to the distribution of that attribute among existing nodes
       at that current time step.
 \item \strong{"t1":} new nodes will be assigned this attribute in proportion
       to the distribution of that attribute among nodes at time 1 (that is,
       the proportions set in the original network for \code{\link{netest}}).
 \item \strong{<Value>:} all new nodes will be assigned this specific value,
       with no variation.
}
For example, the rules list
\code{attr.rules = list(race = "t1", sex = "current", status = 0)}
specifies how the race, sex, and status attributes should be set for incoming
nodes. By default, the rule is "current" for all attributes except status,
in which case it is 0 (that is, all incoming nodes are susceptible).
}

\section{New Modules}{

Built-in network models use a set of module functions that specify how the
individual nodes in the network are subjected to infection, recovery,
demographics, and other processes. Core modules are those listed in the
\code{.FUN} arguments. For each module, there is a default function used in
the simulation. The default infection module, for example, is contained in
the \code{\link{infection.net}} function.

For original models, one may substitute replacement module functions for any
the default functions. New modules may be added to the workflow at each time
step by passing a module function via the \code{...} argument. This functionality
is new to \code{EpiModel} and further documentation will be posted in tutorial
vignettes at the \href{http://statnet.org/trac/wiki/EpiModel}{EpiModel website}.
}
\seealso{
Use \code{\link{param.net}} to specify model parameters and
         \code{\link{init.net}} to specify the initial conditions. Run the
         parameterized model with \code{\link{netsim}}.
}
\keyword{parameterization}

