% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendo.R
\name{as.phylo.transmat}
\alias{as.phylo.transmat}
\title{Convert transmat infection tree into a phylo object}
\usage{
\method{as.phylo}{transmat}(x, collapse.singles, vertex.exit.times, ...)
}
\arguments{
\item{x}{An object of class \code{"transmat"}, the output from
\code{\link{get_transmat}}.}

\item{collapse.singles}{logical, DEPRECATED}

\item{vertex.exit.times}{optional numeric vector providing the time of
departure of vertices, to be used to scale the lengths of branches
reaching to the tips. Index position on vector corresponds to network
id. NA indicates no departure, so branch will extend to the end of the
tree.}

\item{...}{further arguments (unused)}
}
\description{
Converts the edgelist matrix in the \code{transmat} object into
             a \code{phylo} object by doing the required reordering and
             labeling.
}
\details{
Converts a \code{\link{transmat}} object containing information about the
history of a simulated infection into a \code{\link{phylo}} object
representation suitable for plotting as a tree with
\code{\link[ape]{plot.phylo}}. Each infection event becomes a 'node'
(horizontal branch) in the resulting phylo tree, and each network vertex
becomes a 'tip' of the tree. The infection events are labeled with the vertex
id of the infector to make it possible to trace the path of infection.

The infection timing information is included to position the phylo-nodes,
with the lines to the tips drawn to the max time value +1 (unless
\code{vertex.exit.times} are passed in it effectively assumes all vertices
are active/alive until the end of the simulation).

If the transmat contains multiple infection seeds (there are multiple trees
with seperate root nodes) it will return a list of class 'multiPhylo', each
element of which is a phylo object.  See \code{\link[ape]{read.tree}}.

Note that in EpiModel versions <= 1.2.4, the phylo tree was constructed
differently, translating network vertices to both phylo-nodes and tips and
requiring 'collapse.singles' to prune it to an appropriate branching
structure.
}
\examples{
set.seed(10)
nw <- network_initialize(n = 100)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)

est1 <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

param <- param.net(inf.prob = 0.5)
init <- init.net(i.num = 1)
control <- control.net(type = "SI", nsteps = 40, nsims = 1, verbose = FALSE)

mod1 <- netsim(est1, param, init, control)
tm <- get_transmat(mod1)
tmPhylo <- as.phylo.transmat(tm)
plot(tmPhylo, show.node.label = TRUE,
              root.edge = TRUE,
              cex = 0.5)

}
