% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.accessor.R
\name{net-accessor}
\alias{net-accessor}
\alias{get_attr_list}
\alias{get_attr}
\alias{add_attr}
\alias{set_attr}
\alias{append_attr}
\alias{get_epi_list}
\alias{get_epi}
\alias{add_epi}
\alias{set_epi}
\alias{get_param_list}
\alias{get_param}
\alias{add_param}
\alias{set_param}
\alias{get_control_list}
\alias{get_control}
\alias{add_control}
\alias{set_control}
\alias{get_init_list}
\alias{get_init}
\alias{add_init}
\alias{set_init}
\alias{append_core_attr}
\title{Functions to Access and Edit the Master List Object in Network Models}
\usage{
get_attr_list(dat, item = NULL)

get_attr(dat, item, posit_ids = NULL, override.null.error = FALSE)

add_attr(dat, item)

set_attr(dat, item, value, posit_ids = NULL, override.length.check = FALSE)

append_attr(dat, item, value, n.new)

get_epi_list(dat, item = NULL)

get_epi(dat, item, at = NULL, override.null.error = FALSE)

add_epi(dat, item)

set_epi(dat, item, at, value)

get_param_list(dat, item = NULL)

get_param(dat, item, override.null.error = FALSE)

add_param(dat, item)

set_param(dat, item, value)

get_control_list(dat, item = NULL)

get_control(dat, item, override.null.error = FALSE)

add_control(dat, item)

set_control(dat, item, value)

get_init_list(dat, item = NULL)

get_init(dat, item, override.null.error = FALSE)

add_init(dat, item)

set_init(dat, item, value)

append_core_attr(dat, at, n.new)
}
\arguments{
\item{dat}{a Master list object of network models}

\item{item}{a character vector conaining the name of the element to access.
Can be of length > 1 for \code{get_*_list} functions}

\item{posit_ids}{for \code{get_epi} and \code{get_attr}, a numeric vector of
posit_ids or a logical vector to subset the desired \code{item}}

\item{override.null.error}{if TRUE, \code{get_} return NULL if the
\code{item} does not exist instead of throwing an error.
(default = FALSE)}

\item{value}{new value to be attributed in the \code{set_} and \code{append_}
functions}

\item{override.length.check}{if TRUE, \code{set_attr} allows the modification
of the \code{item} size. (default = FALSE)}

\item{n.new}{the number of new nodes to initiate with core attributes}

\item{at}{current time step}
}
\value{
a vector or a list of
vector for \code{get_} functions. And the Master list object for \code{set_}
and \code{add_} functions
}
\description{
These \code{get_}, \code{set_}, \code{append_} and \code{add}
             functions allow a safe and efficient way to retrieve and mutate
             the Master list object of network models (\code{dat}).
}
\section{Core Attribute}{

The \code{append_core_attr} function initialize the attributes necessary for
EpiModel to work (the four core attributes are: "active", "unique_id",
"entrTime", and "exitTime"). These attributes are used in the initialization
phase of the simulation, to create the nodes (see
\code{initialize.net}); and also used when adding nodes during the
simulation (see \code{arrival.net})
}

\section{Mutability}{

The \code{set_}, \code{append_} and \code{add_} functions DO NOT modify the
dat object in place. The result must be assigned back to \code{dat} in order
to be registered \code{dat <- set_*(dat, item, value)}
}

\section{\code{set_} and \code{append_} vs \code{add_}}{

The \code{set_} and \code{append_} functions edit a pre-existing element or
create a new one if it does not exist already by calling the \code{add_}
functions internally.
}

\examples{
dat <- list(
  attr = list(
    active = rbinom(100, 1, 0.9)
  ),
  epi = list(),
  param = list(),
  init = list(),
  control = list(
    nsteps = 150
  )
)

dat <- add_attr(dat, "age")
dat <- set_attr(dat, "age", runif(100))
dat <- set_attr(dat, "status", rbinom(100, 1, 0.9))
dat <- set_attr(dat, "status", rep(1, 150), override.length.check = TRUE)
dat <- append_attr(dat, "status", 1, 10)
dat <- append_attr(dat, "age", NA, 10)
get_attr_list(dat)
get_attr_list(dat, c("age", "active"))
get_attr(dat, "status")
get_attr(dat, "status", c(1, 4))

dat <- add_epi(dat, "i.num")
dat <- set_epi(dat, "i.num", 150, 10)
dat <- set_epi(dat, "s.num", 150, 90)
get_epi_list(dat)
get_epi_list(dat, c("i.num", "s.num"))
get_epi(dat, "i.num")
get_epi(dat, "i.num", c(1, 4))
get_epi(dat, "i.num", rbinom(150, 1, 0.2) == 1)

dat <- add_param(dat, "x")
dat <- set_param(dat, "x", 0.4)
dat <- set_param(dat, "y", 0.8)
get_param_list(dat)
get_param_list(dat, c("x", "y"))
get_param(dat, "x")

dat <- add_init(dat, "x")
dat <- set_init(dat, "x", 0.4)
dat <- set_init(dat, "y", 0.8)
get_init_list(dat)
get_init_list(dat, c("x", "y"))
get_init(dat, "x")

dat <- add_control(dat, "x")
dat <- set_control(dat, "x", 0.4)
dat <- set_control(dat, "y", 0.8)
get_control_list(dat)
get_control_list(dat, c("x", "y"))
get_control(dat, "x")

}
