% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.utils.R
\name{truncate_sim}
\alias{truncate_sim}
\title{Truncate Simulation Time Series}
\usage{
truncate_sim(x, at)
}
\arguments{
\item{x}{Object of class \code{netsim} or \code{icm}.}

\item{at}{Time step at which to left-truncate the time series.}
}
\description{
Left-truncates a simulation epidemiological summary statistics
             and network statistics at a specified time step.
}
\details{
This function would be used when running a follow-up simulation from time
steps \code{b} to \code{c} after a burnin period from time \code{a} to
\code{b}, where the final time window of interest for data analysis is
\code{b} to \code{c} only.
}
\examples{
param <- param.icm(inf.prob = 0.2, act.rate = 0.25)
init <- init.icm(s.num = 500, i.num = 1)
control <- control.icm(type = "SI", nsteps = 200, nsims = 1)
mod1 <- icm(param, init, control)
df <- as.data.frame(mod1)
print(df)
plot(mod1)
mod1$control$nsteps

mod2 <- truncate_sim(mod1, at = 150)
df2 <- as.data.frame(mod2)
print(df2)
plot(mod2)
mod2$control$nsteps

}
