% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netdx.R
\name{make_stats_table}
\alias{make_stats_table}
\title{Create a Summary Table of Simulation Statistics}
\usage{
make_stats_table(stats, targets)
}
\arguments{
\item{stats}{A list of simulated statistics matrices, of length equal to the
number of simulations performed.  Each matrix should have one row for each
simulated network if \code{dynamic == FALSE}, one row for each time step
if \code{dynamic == TRUE}, and one column for each statistic.  The columns
should be named for the statistics they correspond to, with all matrices
having the same statistics, in the same order.  Each matrix may have an
\code{attr}-style attribute named \code{"ess"} attached, giving the
effective sample sizes for the columns of the matrix; if this attribute is
\code{NULL}, then the effective sample sizes will be computed within the
call to \code{make_stats_table}.}

\item{targets}{A vector of target values for the statistics in \code{stats}.
May be named (in which case targets will be matched to statistics based on
column names in matrices in \code{stats}) or unnamed (in which case
targets will be matched to statistics based on position, and the number of
targets must equal the number of columns).}
}
\value{
A \code{data.frame} summarizing the simulated statistics.
}
\description{
Create a Summary Table of Simulation Statistics
}
\keyword{internal}
