% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.netdx}
\alias{print.netdx}
\title{Utility Function for Printing netdx Object}
\usage{
\method{print}{netdx}(x, digits = 3, ...)
}
\arguments{
\item{x}{an object of class \code{netdx}}

\item{digits}{number of digits to print in statistics tables}

\item{...}{additional arguments (currently ignored)}
}
\description{
Prints basic information and statistics from a \code{netdx}
object.
}
\details{
Given a \code{netdx} object, \code{print.netdx} prints the diagnostic method
(static/dynamic), number of simulations, and (if dynamic) the number of time
steps per simulation used in generating the \code{netdx} object, as well as
printing the formation statistics table and (if present) the duration and
dissolution statistics tables.  The statistics tables are interpreted as
follows.

Each row has the name of a particular network statistic.  In the formation
table, these correspond to actual network statistics in the obvious way.
In the duration and dissolution tables, these correspond to dissolution
model dyad types: in a homogeneous dissolution model, all dyads are of the
\code{edges} type; in a heterogeneous dissolution model, a dyad with a
nonzero \code{nodematch} or \code{nodemix} change statistic in the
dissolution model has type equal to that statistic, and has type equal to
\code{edges} otherwise.  The statistics of interest for the duration and
dissolution tables are, respectively, the mean age of extant edges and the
edge dissolution rate, broken down by dissolution model dyad type.  (The
current convention is to treat the mean age and dissolution rate for a
particular dissolution dyad type as 0 on time steps with no edges of that
type; this behavior may be changed in the future.)

The columns are named \code{Target}, \code{Sim Mean}, \code{Pct Diff},
\code{Sim SE}, \code{Z Score}, \code{SD(Sim Means)}, and
\code{SD(Statistic)}.  The \code{Sim Mean} column refers to the mean
statistic value, across all time steps in all simulations in the dynamic
case, and across all sampled networks in all simulations in the static case.
The \code{Sim SE} column refers to the standard error in the mean, estimated
using \code{\link[=effectiveSize]{coda::effectiveSize}}.  The \code{Target}
column indicates the target value (if present) for the statistic, and the
\code{Pct Diff} column gives \code{(Sim Mean - Target)/Target} when
\code{Target} is present.  The \code{Z Score} column gives
\code{(Sim Mean - Target)/(Sim SE)}.  The \code{SD(Sim Means)} column gives
the empirical standard deviation across simulations of the mean statistic
value within simulation, and \code{SD(Statistic)} gives the empirical
standard deviation of the statistic value across all the simulated data.
}
