% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_stan_args}
\alias{create_stan_args}
\title{Create a List of Stan Arguments}
\usage{
create_stan_args(
  model,
  data = NULL,
  init = "random",
  samples = 1000,
  stan_args = NULL,
  method = "exact",
  verbose = FALSE
)
}
\arguments{
\item{model}{A stan model object, defaults to packaged model if not supplied.}

\item{data}{A list of stan data as created by \code{create_stan_data}}

\item{init}{Initial conditions passed to \code{rstan}. Defaults to "random" but can also be a function (
as supplied by \code{create_intitial_conditions}).}

\item{samples}{Numeric, defaults to 1000. The overall number of posterior samples to return (Note: not the
number of samples per chain as is the default in stan).}

\item{stan_args}{A list of stan arguments to be passed to \code{rstan::sampling} or \code{rstan::vb} (when using the "exact"
or "approximate" method). For \code{method = approximate} an additional argument \code{trials} indicates the number of attempts to make
using variational inference before returning an error (as stochastic failure is possible). The default for this is 5.}

\item{method}{A character string defaults to "exact". Also accepts "approximate". Indicates the fitting method to be used
this can either be "exact" (NUTs sampling) or "approximate" (variational inference). The exact approach returns samples
from the posterior whilst the approximate method returns approximate samples. The approximate method is likely to return results
several order of magnitudes faster than the exact method.}

\item{verbose}{Logical, defaults to \code{FALSE}. Should verbose progress messages be returned.}
}
\value{
A list of stan arguments
}
\description{
Generates a list of arguments as required by \code{rstan::sampling} (when \verb{method = "exact}) or
\code{rstan::vb} (when \verb{method = "approximate}). See \code{create_stan_args()} for the defaults and the relevant \code{rstan}
functions for additional options.
}
\examples{

# default settings
create_stan_args()

# approximate settings
create_stan_args(method = "approximate") 
# increasing warmup
create_stan_args(stan_args = list(warmup = 1000))
}
