// Generated by rstantools.  Do not edit by hand.

/*
    EpiNow2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EpiNow2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EpiNow2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_estimate_truncation_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_estimate_truncation");
    reader.add_event(1, 1, "include", "functions/pmfs.stan");
    reader.add_event(1, 0, "start", "functions/pmfs.stan");
    reader.add_event(52, 51, "end", "functions/pmfs.stan");
    reader.add_event(52, 2, "restart", "model_estimate_truncation");
    reader.add_event(52, 2, "include", "functions/observation_model.stan");
    reader.add_event(52, 0, "start", "functions/observation_model.stan");
    reader.add_event(161, 109, "end", "functions/observation_model.stan");
    reader.add_event(161, 3, "restart", "model_estimate_truncation");
    reader.add_event(216, 56, "end", "model_estimate_truncation");
    return reader;
}
template <typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic, 1>
discretised_gamma_pmf(const std::vector<int>& y,
                          const T1__& mu,
                          const T2__& sigma,
                          const int& max_val, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 4;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(y));
        current_statement_begin__ = 5;
        validate_non_negative_index("pmf", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pmf(n);
        stan::math::initialize(pmf, DUMMY_VAR__);
        stan::math::fill(pmf, DUMMY_VAR__);
        current_statement_begin__ = 6;
        local_scalar_t__ trunc_pmf(DUMMY_VAR__);
        (void) trunc_pmf;  // dummy to suppress unused var warning
        stan::math::initialize(trunc_pmf, DUMMY_VAR__);
        stan::math::fill(trunc_pmf, DUMMY_VAR__);
        current_statement_begin__ = 8;
        local_scalar_t__ c_sigma(DUMMY_VAR__);
        (void) c_sigma;  // dummy to suppress unused var warning
        stan::math::initialize(c_sigma, DUMMY_VAR__);
        stan::math::fill(c_sigma, DUMMY_VAR__);
        stan::math::assign(c_sigma,(sigma + 1e-5));
        current_statement_begin__ = 9;
        local_scalar_t__ alpha(DUMMY_VAR__);
        (void) alpha;  // dummy to suppress unused var warning
        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha, DUMMY_VAR__);
        stan::math::assign(alpha,pow((mu / c_sigma), 2));
        current_statement_begin__ = 10;
        local_scalar_t__ beta(DUMMY_VAR__);
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta, DUMMY_VAR__);
        stan::math::assign(beta,(mu / pow(c_sigma, 2)));
        current_statement_begin__ = 12;
        stan::math::assign(alpha, (logical_lte(alpha, 0) ? stan::math::promote_scalar<local_scalar_t__>(1e-5) : stan::math::promote_scalar<local_scalar_t__>(alpha) ));
        current_statement_begin__ = 13;
        stan::math::assign(beta, (logical_lte(beta, 0) ? stan::math::promote_scalar<local_scalar_t__>(1e-5) : stan::math::promote_scalar<local_scalar_t__>(beta) ));
        current_statement_begin__ = 14;
        stan::math::assign(alpha, (is_inf(alpha) ? stan::math::promote_scalar<local_scalar_t__>(1e8) : stan::math::promote_scalar<local_scalar_t__>(alpha) ));
        current_statement_begin__ = 15;
        stan::math::assign(beta, (is_inf(beta) ? stan::math::promote_scalar<local_scalar_t__>(1e8) : stan::math::promote_scalar<local_scalar_t__>(beta) ));
        current_statement_begin__ = 17;
        stan::math::assign(trunc_pmf, (gamma_cdf((max_val + 1), alpha, beta) - gamma_cdf(1, alpha, beta)));
        current_statement_begin__ = 18;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 19;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        ((gamma_cdf((get_base1(y, i, "y", 1) + 1), alpha, beta) - gamma_cdf(get_base1(y, i, "y", 1), alpha, beta)) / trunc_pmf), 
                        "assigning variable pmf");
        }
        current_statement_begin__ = 22;
        return stan::math::promote_scalar<fun_return_scalar_t__>(pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct discretised_gamma_pmf_functor__ {
    template <typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const std::vector<int>& y,
                          const T1__& mu,
                          const T2__& sigma,
                          const int& max_val, std::ostream* pstream__) const {
        return discretised_gamma_pmf(y, mu, sigma, max_val, pstream__);
    }
};
template <typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic, 1>
discretised_lognormal_pmf(const std::vector<int>& y,
                              const T1__& mu,
                              const T2__& sigma,
                              const int& max_val, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 27;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(y));
        current_statement_begin__ = 28;
        validate_non_negative_index("pmf", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pmf(n);
        stan::math::initialize(pmf, DUMMY_VAR__);
        stan::math::fill(pmf, DUMMY_VAR__);
        current_statement_begin__ = 29;
        local_scalar_t__ small(DUMMY_VAR__);
        (void) small;  // dummy to suppress unused var warning
        stan::math::initialize(small, DUMMY_VAR__);
        stan::math::fill(small, DUMMY_VAR__);
        stan::math::assign(small,1e-5);
        current_statement_begin__ = 30;
        local_scalar_t__ c_sigma(DUMMY_VAR__);
        (void) c_sigma;  // dummy to suppress unused var warning
        stan::math::initialize(c_sigma, DUMMY_VAR__);
        stan::math::fill(c_sigma, DUMMY_VAR__);
        stan::math::assign(c_sigma,(logical_lte(sigma, 0) ? stan::math::promote_scalar<local_scalar_t__>(small) : stan::math::promote_scalar<local_scalar_t__>(sigma) ));
        current_statement_begin__ = 31;
        local_scalar_t__ c_mu(DUMMY_VAR__);
        (void) c_mu;  // dummy to suppress unused var warning
        stan::math::initialize(c_mu, DUMMY_VAR__);
        stan::math::fill(c_mu, DUMMY_VAR__);
        stan::math::assign(c_mu,(logical_lte(mu, 0) ? stan::math::promote_scalar<local_scalar_t__>(small) : stan::math::promote_scalar<local_scalar_t__>(mu) ));
        current_statement_begin__ = 32;
        validate_non_negative_index("adj_y", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> adj_y(n);
        stan::math::initialize(adj_y, DUMMY_VAR__);
        stan::math::fill(adj_y, DUMMY_VAR__);
        stan::math::assign(adj_y,add(to_vector(y), small));
        current_statement_begin__ = 33;
        validate_non_negative_index("upper_y", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> upper_y(n);
        stan::math::initialize(upper_y, DUMMY_VAR__);
        stan::math::fill(upper_y, DUMMY_VAR__);
        stan::math::assign(upper_y,divide(subtract(stan::math::log(add(adj_y, 1)), c_mu), c_sigma));
        current_statement_begin__ = 34;
        validate_non_negative_index("lower_y", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lower_y(n);
        stan::math::initialize(lower_y, DUMMY_VAR__);
        stan::math::fill(lower_y, DUMMY_VAR__);
        stan::math::assign(lower_y,divide(subtract(stan::math::log(adj_y), c_mu), c_sigma));
        current_statement_begin__ = 35;
        local_scalar_t__ max_cdf(DUMMY_VAR__);
        (void) max_cdf;  // dummy to suppress unused var warning
        stan::math::initialize(max_cdf, DUMMY_VAR__);
        stan::math::fill(max_cdf, DUMMY_VAR__);
        stan::math::assign(max_cdf,normal_cdf(((stan::math::log((max_val + small)) - c_mu) / c_sigma), 0.0, 1.0));
        current_statement_begin__ = 36;
        local_scalar_t__ min_cdf(DUMMY_VAR__);
        (void) min_cdf;  // dummy to suppress unused var warning
        stan::math::initialize(min_cdf, DUMMY_VAR__);
        stan::math::fill(min_cdf, DUMMY_VAR__);
        stan::math::assign(min_cdf,normal_cdf(((stan::math::log(small) - c_mu) / c_sigma), 0.0, 1.0));
        current_statement_begin__ = 37;
        local_scalar_t__ trunc_cdf(DUMMY_VAR__);
        (void) trunc_cdf;  // dummy to suppress unused var warning
        stan::math::initialize(trunc_cdf, DUMMY_VAR__);
        stan::math::fill(trunc_cdf, DUMMY_VAR__);
        stan::math::assign(trunc_cdf,(max_cdf - min_cdf));
        current_statement_begin__ = 38;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 39;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        ((normal_cdf(get_base1(upper_y, i, "upper_y", 1), 0.0, 1.0) - normal_cdf(get_base1(lower_y, i, "lower_y", 1), 0.0, 1.0)) / trunc_cdf), 
                        "assigning variable pmf");
        }
        current_statement_begin__ = 42;
        return stan::math::promote_scalar<fun_return_scalar_t__>(pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct discretised_lognormal_pmf_functor__ {
    template <typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const std::vector<int>& y,
                              const T1__& mu,
                              const T2__& sigma,
                              const int& max_val, std::ostream* pstream__) const {
        return discretised_lognormal_pmf(y, mu, sigma, max_val, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
reverse_mf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& pmf,
               const int& max_pmf, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 47;
        validate_non_negative_index("rev_pmf", "max_pmf", max_pmf);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rev_pmf(max_pmf);
        stan::math::initialize(rev_pmf, DUMMY_VAR__);
        stan::math::fill(rev_pmf, DUMMY_VAR__);
        current_statement_begin__ = 48;
        for (int d = 1; d <= max_pmf; ++d) {
            current_statement_begin__ = 49;
            stan::model::assign(rev_pmf, 
                        stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                        get_base1(pmf, ((max_pmf - d) + 1), "pmf", 1), 
                        "assigning variable rev_pmf");
        }
        current_statement_begin__ = 51;
        return stan::math::promote_scalar<fun_return_scalar_t__>(rev_pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct reverse_mf_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& pmf,
               const int& max_pmf, std::ostream* pstream__) const {
        return reverse_mf(pmf, max_pmf, pstream__);
    }
};
template <typename T0__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
day_of_week_effect(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                       const std::vector<int>& day_of_week,
                       const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& effect, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 55;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 57;
        validate_non_negative_index("scaled_effect", "7", 7);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_effect(7);
        stan::math::initialize(scaled_effect, DUMMY_VAR__);
        stan::math::fill(scaled_effect, DUMMY_VAR__);
        stan::math::assign(scaled_effect,multiply(7, effect));
        current_statement_begin__ = 58;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 59;
        for (int s = 1; s <= t; ++s) {
            current_statement_begin__ = 61;
            stan::model::assign(scaled_reports, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        (get_base1(reports, s, "reports", 1) * get_base1(scaled_effect, get_base1(day_of_week, s, "day_of_week", 1), "scaled_effect", 1)), 
                        "assigning variable scaled_reports");
        }
        current_statement_begin__ = 63;
        return stan::math::promote_scalar<fun_return_scalar_t__>(scaled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct day_of_week_effect_functor__ {
    template <typename T0__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                       const std::vector<int>& day_of_week,
                       const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& effect, std::ostream* pstream__) const {
        return day_of_week_effect(reports, day_of_week, effect, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
scale_obs(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
              const T1__& frac_obs, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 68;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 69;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 70;
        stan::math::assign(scaled_reports, multiply(reports, frac_obs));
        current_statement_begin__ = 71;
        return stan::math::promote_scalar<fun_return_scalar_t__>(scaled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct scale_obs_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
              const T1__& frac_obs, std::ostream* pstream__) const {
        return scale_obs(reports, frac_obs, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
truncation_cmf(const T0__& trunc_mean,
                   const T1__& trunc_sd,
                   const int& trunc_max, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 75;
        validate_non_negative_index("trunc_indexes", "trunc_max", trunc_max);
        std::vector<int  > trunc_indexes(trunc_max, int(0));
        stan::math::fill(trunc_indexes, std::numeric_limits<int>::min());
        current_statement_begin__ = 76;
        validate_non_negative_index("cmf", "trunc_max", trunc_max);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> cmf(trunc_max);
        stan::math::initialize(cmf, DUMMY_VAR__);
        stan::math::fill(cmf, DUMMY_VAR__);
        current_statement_begin__ = 77;
        for (int i = 1; i <= trunc_max; ++i) {
            current_statement_begin__ = 78;
            stan::model::assign(trunc_indexes, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        (i - 1), 
                        "assigning variable trunc_indexes");
        }
        current_statement_begin__ = 80;
        stan::math::assign(cmf, discretised_lognormal_pmf(trunc_indexes, trunc_mean, trunc_sd, trunc_max, pstream__));
        current_statement_begin__ = 81;
        stan::model::assign(cmf, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    (get_base1(cmf, 1, "cmf", 1) + 1e-8), 
                    "assigning variable cmf");
        current_statement_begin__ = 82;
        stan::math::assign(cmf, cumulative_sum(cmf));
        current_statement_begin__ = 83;
        stan::math::assign(cmf, reverse_mf(cmf, trunc_max, pstream__));
        current_statement_begin__ = 84;
        return stan::math::promote_scalar<fun_return_scalar_t__>(cmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct truncation_cmf_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const T0__& trunc_mean,
                   const T1__& trunc_sd,
                   const int& trunc_max, std::ostream* pstream__) const {
        return truncation_cmf(trunc_mean, trunc_sd, trunc_max, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
truncate(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
             const std::vector<T1__>& truncation_mean,
             const std::vector<T2__>& truncation_sd,
             const std::vector<int>& truncation_max,
             const int& reconstruct, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 89;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 90;
        int truncation(0);
        (void) truncation;  // dummy to suppress unused var warning
        stan::math::fill(truncation, std::numeric_limits<int>::min());
        stan::math::assign(truncation,num_elements(truncation_mean));
        current_statement_begin__ = 91;
        validate_non_negative_index("trunc_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> trunc_reports(t);
        stan::math::initialize(trunc_reports, DUMMY_VAR__);
        stan::math::fill(trunc_reports, DUMMY_VAR__);
        stan::math::assign(trunc_reports,reports);
        current_statement_begin__ = 92;
        if (as_bool(truncation)) {
            {
            current_statement_begin__ = 94;
            int trunc_max(0);
            (void) trunc_max;  // dummy to suppress unused var warning
            stan::math::fill(trunc_max, std::numeric_limits<int>::min());
            stan::math::assign(trunc_max,(logical_gt(get_base1(truncation_max, 1, "truncation_max", 1), t) ? t : get_base1(truncation_max, 1, "truncation_max", 1) ));
            current_statement_begin__ = 95;
            validate_non_negative_index("trunc_indexes", "trunc_max", trunc_max);
            std::vector<int  > trunc_indexes(trunc_max, int(0));
            stan::math::fill(trunc_indexes, std::numeric_limits<int>::min());
            current_statement_begin__ = 96;
            validate_non_negative_index("cmf", "trunc_max", trunc_max);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> cmf(trunc_max);
            stan::math::initialize(cmf, DUMMY_VAR__);
            stan::math::fill(cmf, DUMMY_VAR__);
            current_statement_begin__ = 97;
            int first_t(0);
            (void) first_t;  // dummy to suppress unused var warning
            stan::math::fill(first_t, std::numeric_limits<int>::min());
            stan::math::assign(first_t,((t - trunc_max) + 1));
            current_statement_begin__ = 98;
            stan::math::assign(cmf, truncation_cmf(get_base1(truncation_mean, 1, "truncation_mean", 1), get_base1(truncation_sd, 1, "truncation_sd", 1), trunc_max, pstream__));
            current_statement_begin__ = 100;
            if (as_bool(reconstruct)) {
                current_statement_begin__ = 101;
                stan::model::assign(trunc_reports, 
                            stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), 
                            stan::model::deep_copy(elt_divide(stan::model::rvalue(trunc_reports, stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), "trunc_reports"), cmf)), 
                            "assigning variable trunc_reports");
            } else {
                current_statement_begin__ = 103;
                stan::model::assign(trunc_reports, 
                            stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), 
                            stan::model::deep_copy(elt_multiply(stan::model::rvalue(trunc_reports, stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), "trunc_reports"), cmf)), 
                            "assigning variable trunc_reports");
            }
            }
        }
        current_statement_begin__ = 106;
        return stan::math::promote_scalar<fun_return_scalar_t__>(trunc_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct truncate_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
             const std::vector<T1__>& truncation_mean,
             const std::vector<T2__>& truncation_sd,
             const std::vector<int>& truncation_max,
             const int& reconstruct, std::ostream* pstream__) const {
        return truncate(reports, truncation_mean, truncation_sd, truncation_max, reconstruct, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
void
truncation_lp(const std::vector<T0__>& truncation_mean,
                  const std::vector<T1__>& truncation_sd,
                  const std::vector<T2__>& trunc_mean_mean,
                  const std::vector<T3__>& trunc_mean_sd,
                  const std::vector<T4__>& trunc_sd_mean,
                  const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 112;
        int truncation(0);
        (void) truncation;  // dummy to suppress unused var warning
        stan::math::fill(truncation, std::numeric_limits<int>::min());
        stan::math::assign(truncation,num_elements(truncation_mean));
        current_statement_begin__ = 113;
        if (as_bool(truncation)) {
            current_statement_begin__ = 114;
            lp_accum__.add(normal_log<propto__>(truncation_mean, trunc_mean_mean, trunc_mean_sd));
            current_statement_begin__ = 115;
            lp_accum__.add(normal_log<propto__>(truncation_sd, trunc_sd_mean, trunc_sd_sd));
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct truncation_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<T0__>& truncation_mean,
                  const std::vector<T1__>& truncation_sd,
                  const std::vector<T2__>& trunc_mean_mean,
                  const std::vector<T3__>& trunc_mean_sd,
                  const std::vector<T4__>& trunc_sd_mean,
                  const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return truncation_lp(truncation_mean, truncation_sd, trunc_mean_mean, trunc_mean_sd, trunc_sd_mean, trunc_sd_sd, lp__, lp_accum__, pstream__);
    }
};
template <typename T1__, typename T2__, typename T5__, typename T_lp__, typename T_lp_accum__>
void
report_lp(const std::vector<int>& cases,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
              const std::vector<T2__>& rep_phi,
              const int& phi_prior,
              const int& model_type,
              const T5__& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T5__, T_lp__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 122;
        local_scalar_t__ sqrt_phi(DUMMY_VAR__);
        (void) sqrt_phi;  // dummy to suppress unused var warning
        stan::math::initialize(sqrt_phi, DUMMY_VAR__);
        stan::math::fill(sqrt_phi, DUMMY_VAR__);
        current_statement_begin__ = 123;
        if (as_bool(model_type)) {
            current_statement_begin__ = 125;
            lp_accum__.add(normal_log<propto__>(get_base1(rep_phi, model_type, "rep_phi", 1), 0, phi_prior));
            if (get_base1(rep_phi, model_type, "rep_phi", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-normal_ccdf_log(0, 0, phi_prior));
            current_statement_begin__ = 126;
            stan::math::assign(sqrt_phi, (1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
            current_statement_begin__ = 128;
            if (as_bool(logical_gt(sqrt_phi, 1e4))) {
                current_statement_begin__ = 129;
                lp_accum__.add((poisson_log(cases, reports) * weight));
            } else {
                current_statement_begin__ = 131;
                lp_accum__.add((neg_binomial_2_log(cases, reports, sqrt_phi) * weight));
            }
        } else {
            current_statement_begin__ = 134;
            lp_accum__.add((poisson_log(cases, reports) * weight));
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_lp_functor__ {
    template <typename T1__, typename T2__, typename T5__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<int>& cases,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
              const std::vector<T2__>& rep_phi,
              const int& phi_prior,
              const int& model_type,
              const T5__& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return report_lp(cases, reports, rep_phi, phi_prior, model_type, weight, lp__, lp_accum__, pstream__);
    }
};
template <typename T1__, typename T2__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic, 1>
report_log_lik(const std::vector<int>& cases,
                   const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
                   const std::vector<T2__>& rep_phi,
                   const int& model_type,
                   const T4__& weight, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 140;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 141;
        validate_non_negative_index("log_lik", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(t);
        stan::math::initialize(log_lik, DUMMY_VAR__);
        stan::math::fill(log_lik, DUMMY_VAR__);
        current_statement_begin__ = 142;
        if (as_bool(model_type)) {
            {
            current_statement_begin__ = 144;
            local_scalar_t__ sqrt_phi(DUMMY_VAR__);
            (void) sqrt_phi;  // dummy to suppress unused var warning
            stan::math::initialize(sqrt_phi, DUMMY_VAR__);
            stan::math::fill(sqrt_phi, DUMMY_VAR__);
            stan::math::assign(sqrt_phi,(1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
            current_statement_begin__ = 146;
            if (as_bool(logical_gt(sqrt_phi, 1e4))) {
                current_statement_begin__ = 147;
                for (int i = 1; i <= t; ++i) {
                    current_statement_begin__ = 148;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (poisson_log(get_base1(cases, i, "cases", 1), get_base1(reports, i, "reports", 1)) * weight), 
                                "assigning variable log_lik");
                }
            } else {
                current_statement_begin__ = 151;
                for (int i = 1; i <= t; ++i) {
                    current_statement_begin__ = 152;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (neg_binomial_2_log(get_base1(cases, i, "cases", 1), get_base1(reports, i, "reports", 1), sqrt_phi) * weight), 
                                "assigning variable log_lik");
                }
            }
            }
        } else {
            current_statement_begin__ = 156;
            for (int i = 1; i <= t; ++i) {
                current_statement_begin__ = 157;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (poisson_log(get_base1(cases, i, "cases", 1), get_base1(reports, i, "reports", 1)) * weight), 
                            "assigning variable log_lik");
            }
        }
        current_statement_begin__ = 160;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_lik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_log_lik_functor__ {
    template <typename T1__, typename T2__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic, 1>
    operator()(const std::vector<int>& cases,
                   const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
                   const std::vector<T2__>& rep_phi,
                   const int& model_type,
                   const T4__& weight, std::ostream* pstream__) const {
        return report_log_lik(cases, reports, rep_phi, model_type, weight, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_estimate_truncation
  : public stan::model::model_base_crtp<model_estimate_truncation> {
private:
        int t;
        int obs_sets;
        std::vector<std::vector<int> > obs;
        std::vector<int> obs_dist;
        std::vector<int> trunc_max;
public:
    model_estimate_truncation(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_estimate_truncation(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_estimate_truncation_namespace::model_estimate_truncation";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 164;
            context__.validate_dims("data initialization", "t", "int", context__.to_vec());
            t = int(0);
            vals_i__ = context__.vals_i("t");
            pos__ = 0;
            t = vals_i__[pos__++];
            current_statement_begin__ = 165;
            context__.validate_dims("data initialization", "obs_sets", "int", context__.to_vec());
            obs_sets = int(0);
            vals_i__ = context__.vals_i("obs_sets");
            pos__ = 0;
            obs_sets = vals_i__[pos__++];
            current_statement_begin__ = 166;
            validate_non_negative_index("obs", "t", t);
            validate_non_negative_index("obs", "obs_sets", obs_sets);
            context__.validate_dims("data initialization", "obs", "int", context__.to_vec(t,obs_sets));
            obs = std::vector<std::vector<int> >(t, std::vector<int>(obs_sets, int(0)));
            vals_i__ = context__.vals_i("obs");
            pos__ = 0;
            size_t obs_k_0_max__ = t;
            size_t obs_k_1_max__ = obs_sets;
            for (size_t k_1__ = 0; k_1__ < obs_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < obs_k_0_max__; ++k_0__) {
                    obs[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 167;
            validate_non_negative_index("obs_dist", "obs_sets", obs_sets);
            context__.validate_dims("data initialization", "obs_dist", "int", context__.to_vec(obs_sets));
            obs_dist = std::vector<int>(obs_sets, int(0));
            vals_i__ = context__.vals_i("obs_dist");
            pos__ = 0;
            size_t obs_dist_k_0_max__ = obs_sets;
            for (size_t k_0__ = 0; k_0__ < obs_dist_k_0_max__; ++k_0__) {
                obs_dist[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 168;
            validate_non_negative_index("trunc_max", "1", 1);
            context__.validate_dims("data initialization", "trunc_max", "int", context__.to_vec(1));
            trunc_max = std::vector<int>(1, int(0));
            vals_i__ = context__.vals_i("trunc_max");
            pos__ = 0;
            size_t trunc_max_k_0_max__ = 1;
            for (size_t k_0__ = 0; k_0__ < trunc_max_k_0_max__; ++k_0__) {
                trunc_max[k_0__] = vals_i__[pos__++];
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 171;
            validate_non_negative_index("logmean", "1", 1);
            num_params_r__ += (1 * 1);
            current_statement_begin__ = 172;
            validate_non_negative_index("logsd", "1", 1);
            num_params_r__ += (1 * 1);
            current_statement_begin__ = 173;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_estimate_truncation() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 171;
        if (!(context__.contains_r("logmean")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable logmean missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("logmean");
        pos__ = 0U;
        validate_non_negative_index("logmean", "1", 1);
        context__.validate_dims("parameter initialization", "logmean", "double", context__.to_vec(1));
        std::vector<double> logmean(1, double(0));
        size_t logmean_k_0_max__ = 1;
        for (size_t k_0__ = 0; k_0__ < logmean_k_0_max__; ++k_0__) {
            logmean[k_0__] = vals_r__[pos__++];
        }
        size_t logmean_i_0_max__ = 1;
        for (size_t i_0__ = 0; i_0__ < logmean_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(logmean[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable logmean: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 172;
        if (!(context__.contains_r("logsd")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable logsd missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("logsd");
        pos__ = 0U;
        validate_non_negative_index("logsd", "1", 1);
        context__.validate_dims("parameter initialization", "logsd", "double", context__.to_vec(1));
        std::vector<double> logsd(1, double(0));
        size_t logsd_k_0_max__ = 1;
        for (size_t k_0__ = 0; k_0__ < logsd_k_0_max__; ++k_0__) {
            logsd[k_0__] = vals_r__[pos__++];
        }
        size_t logsd_i_0_max__ = 1;
        for (size_t i_0__ = 0; i_0__ < logsd_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, logsd[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable logsd: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 173;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "phi", "double", context__.to_vec());
        double phi(0);
        phi = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, phi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 171;
            std::vector<local_scalar_t__> logmean;
            size_t logmean_d_0_max__ = 1;
            logmean.reserve(logmean_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < logmean_d_0_max__; ++d_0__) {
                if (jacobian__)
                    logmean.push_back(in__.scalar_constrain(lp__));
                else
                    logmean.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 172;
            std::vector<local_scalar_t__> logsd;
            size_t logsd_d_0_max__ = 1;
            logsd.reserve(logsd_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < logsd_d_0_max__; ++d_0__) {
                if (jacobian__)
                    logsd.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    logsd.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 173;
            local_scalar_t__ phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.scalar_lb_constrain(0, lp__);
            else
                phi = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 176;
            validate_non_negative_index("trunc_obs", "get_base1(trunc_max, 1, \"trunc_max\", 1)", get_base1(trunc_max, 1, "trunc_max", 1));
            validate_non_negative_index("trunc_obs", "(obs_sets - 1)", (obs_sets - 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> trunc_obs(get_base1(trunc_max, 1, "trunc_max", 1), (obs_sets - 1));
            stan::math::initialize(trunc_obs, DUMMY_VAR__);
            stan::math::fill(trunc_obs, DUMMY_VAR__);
            current_statement_begin__ = 177;
            local_scalar_t__ sqrt_phi;
            (void) sqrt_phi;  // dummy to suppress unused var warning
            stan::math::initialize(sqrt_phi, DUMMY_VAR__);
            stan::math::fill(sqrt_phi, DUMMY_VAR__);
            stan::math::assign(sqrt_phi,(1 / stan::math::sqrt(phi)));
            // transformed parameters block statements
            {
            current_statement_begin__ = 179;
            validate_non_negative_index("last_obs", "t", t);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> last_obs(t);
            stan::math::initialize(last_obs, DUMMY_VAR__);
            stan::math::fill(last_obs, DUMMY_VAR__);
            current_statement_begin__ = 181;
            stan::math::assign(last_obs, truncate(to_vector(stan::model::rvalue(obs, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(obs_sets), stan::model::nil_index_list())), "obs")), logmean, logsd, trunc_max, 1, pstream__));
            current_statement_begin__ = 183;
            for (int i = 1; i <= (obs_sets - 1); ++i) {
                {
                current_statement_begin__ = 184;
                int end_t(0);
                (void) end_t;  // dummy to suppress unused var warning
                stan::math::fill(end_t, std::numeric_limits<int>::min());
                stan::math::assign(end_t,(t - get_base1(obs_dist, i, "obs_dist", 1)));
                current_statement_begin__ = 185;
                int start_t(0);
                (void) start_t;  // dummy to suppress unused var warning
                stan::math::fill(start_t, std::numeric_limits<int>::min());
                stan::math::assign(start_t,((end_t - get_base1(trunc_max, 1, "trunc_max", 1)) + 1));
                current_statement_begin__ = 186;
                stan::model::assign(trunc_obs, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            truncate(stan::model::rvalue(last_obs, stan::model::cons_list(stan::model::index_min_max(start_t, end_t), stan::model::nil_index_list()), "last_obs"), logmean, logsd, trunc_max, 0, pstream__), 
                            "assigning variable trunc_obs");
                }
            }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 176;
            size_t trunc_obs_j_1_max__ = get_base1(trunc_max, 1, "trunc_max", 1);
            size_t trunc_obs_j_2_max__ = (obs_sets - 1);
            for (size_t j_1__ = 0; j_1__ < trunc_obs_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < trunc_obs_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(trunc_obs(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: trunc_obs" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable trunc_obs: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 177;
            if (stan::math::is_uninitialized(sqrt_phi)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: sqrt_phi";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sqrt_phi: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            // model body
            current_statement_begin__ = 192;
            lp_accum__.add(normal_log<propto__>(logmean, 0, 1));
            current_statement_begin__ = 193;
            lp_accum__.add(normal_log<propto__>(get_base1(logsd, 1, "logsd", 1), 0, 1));
            if (get_base1(logsd, 1, "logsd", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-normal_ccdf_log(0, 0, 1));
            current_statement_begin__ = 194;
            lp_accum__.add(normal_log<propto__>(phi, 0, 1));
            if (phi < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-normal_ccdf_log(0, 0, 1));
            current_statement_begin__ = 196;
            for (int i = 1; i <= (obs_sets - 1); ++i) {
                {
                current_statement_begin__ = 197;
                int start_t(0);
                (void) start_t;  // dummy to suppress unused var warning
                stan::math::fill(start_t, std::numeric_limits<int>::min());
                stan::math::assign(start_t,((t - get_base1(obs_dist, i, "obs_dist", 1)) - get_base1(trunc_max, 1, "trunc_max", 1)));
                current_statement_begin__ = 198;
                for (int j = 1; j <= get_base1(trunc_max, 1, "trunc_max", 1); ++j) {
                    current_statement_begin__ = 199;
                    lp_accum__.add(neg_binomial_2_log<propto__>(get_base1(get_base1(obs, (start_t + j), "obs", 1), i, "obs", 2), get_base1(trunc_obs, j, i, "trunc_obs", 1), sqrt_phi));
                }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("logmean");
        names__.push_back("logsd");
        names__.push_back("phi");
        names__.push_back("trunc_obs");
        names__.push_back("sqrt_phi");
        names__.push_back("recon_obs");
        names__.push_back("cmf");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(get_base1(trunc_max, 1, "trunc_max", 1));
        dims__.push_back((obs_sets - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(get_base1(trunc_max, 1, "trunc_max", 1));
        dims__.push_back(obs_sets);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(get_base1(trunc_max, 1, "trunc_max", 1));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_estimate_truncation_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<double> logmean;
        size_t logmean_d_0_max__ = 1;
        logmean.reserve(logmean_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < logmean_d_0_max__; ++d_0__) {
            logmean.push_back(in__.scalar_constrain());
        }
        size_t logmean_k_0_max__ = 1;
        for (size_t k_0__ = 0; k_0__ < logmean_k_0_max__; ++k_0__) {
            vars__.push_back(logmean[k_0__]);
        }
        std::vector<double> logsd;
        size_t logsd_d_0_max__ = 1;
        logsd.reserve(logsd_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < logsd_d_0_max__; ++d_0__) {
            logsd.push_back(in__.scalar_lb_constrain(0));
        }
        size_t logsd_k_0_max__ = 1;
        for (size_t k_0__ = 0; k_0__ < logsd_k_0_max__; ++k_0__) {
            vars__.push_back(logsd[k_0__]);
        }
        double phi = in__.scalar_lb_constrain(0);
        vars__.push_back(phi);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 176;
            validate_non_negative_index("trunc_obs", "get_base1(trunc_max, 1, \"trunc_max\", 1)", get_base1(trunc_max, 1, "trunc_max", 1));
            validate_non_negative_index("trunc_obs", "(obs_sets - 1)", (obs_sets - 1));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> trunc_obs(get_base1(trunc_max, 1, "trunc_max", 1), (obs_sets - 1));
            stan::math::initialize(trunc_obs, DUMMY_VAR__);
            stan::math::fill(trunc_obs, DUMMY_VAR__);
            current_statement_begin__ = 177;
            double sqrt_phi;
            (void) sqrt_phi;  // dummy to suppress unused var warning
            stan::math::initialize(sqrt_phi, DUMMY_VAR__);
            stan::math::fill(sqrt_phi, DUMMY_VAR__);
            stan::math::assign(sqrt_phi,(1 / stan::math::sqrt(phi)));
            // do transformed parameters statements
            {
            current_statement_begin__ = 179;
            validate_non_negative_index("last_obs", "t", t);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> last_obs(t);
            stan::math::initialize(last_obs, DUMMY_VAR__);
            stan::math::fill(last_obs, DUMMY_VAR__);
            current_statement_begin__ = 181;
            stan::math::assign(last_obs, truncate(to_vector(stan::model::rvalue(obs, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(obs_sets), stan::model::nil_index_list())), "obs")), logmean, logsd, trunc_max, 1, pstream__));
            current_statement_begin__ = 183;
            for (int i = 1; i <= (obs_sets - 1); ++i) {
                {
                current_statement_begin__ = 184;
                int end_t(0);
                (void) end_t;  // dummy to suppress unused var warning
                stan::math::fill(end_t, std::numeric_limits<int>::min());
                stan::math::assign(end_t,(t - get_base1(obs_dist, i, "obs_dist", 1)));
                current_statement_begin__ = 185;
                int start_t(0);
                (void) start_t;  // dummy to suppress unused var warning
                stan::math::fill(start_t, std::numeric_limits<int>::min());
                stan::math::assign(start_t,((end_t - get_base1(trunc_max, 1, "trunc_max", 1)) + 1));
                current_statement_begin__ = 186;
                stan::model::assign(trunc_obs, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            truncate(stan::model::rvalue(last_obs, stan::model::cons_list(stan::model::index_min_max(start_t, end_t), stan::model::nil_index_list()), "last_obs"), logmean, logsd, trunc_max, 0, pstream__), 
                            "assigning variable trunc_obs");
                }
            }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t trunc_obs_j_2_max__ = (obs_sets - 1);
                size_t trunc_obs_j_1_max__ = get_base1(trunc_max, 1, "trunc_max", 1);
                for (size_t j_2__ = 0; j_2__ < trunc_obs_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < trunc_obs_j_1_max__; ++j_1__) {
                        vars__.push_back(trunc_obs(j_1__, j_2__));
                    }
                }
                vars__.push_back(sqrt_phi);
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 204;
            validate_non_negative_index("recon_obs", "get_base1(trunc_max, 1, \"trunc_max\", 1)", get_base1(trunc_max, 1, "trunc_max", 1));
            validate_non_negative_index("recon_obs", "obs_sets", obs_sets);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> recon_obs(get_base1(trunc_max, 1, "trunc_max", 1), obs_sets);
            stan::math::initialize(recon_obs, DUMMY_VAR__);
            stan::math::fill(recon_obs, DUMMY_VAR__);
            current_statement_begin__ = 205;
            validate_non_negative_index("cmf", "get_base1(trunc_max, 1, \"trunc_max\", 1)", get_base1(trunc_max, 1, "trunc_max", 1));
            Eigen::Matrix<double, Eigen::Dynamic, 1> cmf(get_base1(trunc_max, 1, "trunc_max", 1));
            stan::math::initialize(cmf, DUMMY_VAR__);
            stan::math::fill(cmf, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 207;
            for (int i = 1; i <= obs_sets; ++i) {
                {
                current_statement_begin__ = 208;
                int end_t(0);
                (void) end_t;  // dummy to suppress unused var warning
                stan::math::fill(end_t, std::numeric_limits<int>::min());
                stan::math::assign(end_t,(t - get_base1(obs_dist, i, "obs_dist", 1)));
                current_statement_begin__ = 209;
                int start_t(0);
                (void) start_t;  // dummy to suppress unused var warning
                stan::math::fill(start_t, std::numeric_limits<int>::min());
                stan::math::assign(start_t,((end_t - get_base1(trunc_max, 1, "trunc_max", 1)) + 1));
                current_statement_begin__ = 210;
                stan::model::assign(recon_obs, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            truncate(to_vector(stan::model::rvalue(obs, stan::model::cons_list(stan::model::index_min_max(start_t, end_t), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "obs")), logmean, logsd, trunc_max, 1, pstream__), 
                            "assigning variable recon_obs");
                }
            }
            current_statement_begin__ = 213;
            stan::math::assign(cmf, truncation_cmf(get_base1(logmean, 1, "logmean", 1), get_base1(logsd, 1, "logsd", 1), get_base1(trunc_max, 1, "trunc_max", 1), pstream__));
            // validate, write generated quantities
            current_statement_begin__ = 204;
            size_t recon_obs_j_2_max__ = obs_sets;
            size_t recon_obs_j_1_max__ = get_base1(trunc_max, 1, "trunc_max", 1);
            for (size_t j_2__ = 0; j_2__ < recon_obs_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < recon_obs_j_1_max__; ++j_1__) {
                    vars__.push_back(recon_obs(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 205;
            size_t cmf_j_1_max__ = get_base1(trunc_max, 1, "trunc_max", 1);
            for (size_t j_1__ = 0; j_1__ < cmf_j_1_max__; ++j_1__) {
                vars__.push_back(cmf(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_estimate_truncation";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t logmean_k_0_max__ = 1;
        for (size_t k_0__ = 0; k_0__ < logmean_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logmean" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t logsd_k_0_max__ = 1;
        for (size_t k_0__ = 0; k_0__ < logsd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logsd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t trunc_obs_j_2_max__ = (obs_sets - 1);
            size_t trunc_obs_j_1_max__ = get_base1(trunc_max, 1, "trunc_max", 1);
            for (size_t j_2__ = 0; j_2__ < trunc_obs_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < trunc_obs_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "trunc_obs" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "sqrt_phi";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t recon_obs_j_2_max__ = obs_sets;
        size_t recon_obs_j_1_max__ = get_base1(trunc_max, 1, "trunc_max", 1);
        for (size_t j_2__ = 0; j_2__ < recon_obs_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < recon_obs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "recon_obs" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t cmf_j_1_max__ = get_base1(trunc_max, 1, "trunc_max", 1);
        for (size_t j_1__ = 0; j_1__ < cmf_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cmf" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t logmean_k_0_max__ = 1;
        for (size_t k_0__ = 0; k_0__ < logmean_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logmean" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t logsd_k_0_max__ = 1;
        for (size_t k_0__ = 0; k_0__ < logsd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logsd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t trunc_obs_j_2_max__ = (obs_sets - 1);
            size_t trunc_obs_j_1_max__ = get_base1(trunc_max, 1, "trunc_max", 1);
            for (size_t j_2__ = 0; j_2__ < trunc_obs_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < trunc_obs_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "trunc_obs" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "sqrt_phi";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t recon_obs_j_2_max__ = obs_sets;
        size_t recon_obs_j_1_max__ = get_base1(trunc_max, 1, "trunc_max", 1);
        for (size_t j_2__ = 0; j_2__ < recon_obs_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < recon_obs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "recon_obs" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t cmf_j_1_max__ = get_base1(trunc_max, 1, "trunc_max", 1);
        for (size_t j_1__ = 0; j_1__ < cmf_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cmf" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_estimate_truncation_namespace::model_estimate_truncation stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
